% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_ssh_public_key}
\alias{iam_get_ssh_public_key}
\title{Retrieves the specified SSH public key, including metadata about the key}
\usage{
iam_get_ssh_public_key(UserName, SSHPublicKeyId, Encoding)
}
\arguments{
\item{UserName}{[required] The name of the IAM user associated with the SSH public key.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{SSHPublicKeyId}{[required] The unique identifier for the SSH public key.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that can consist of any upper or lowercased letter or digit.}

\item{Encoding}{[required] Specifies the public key encoding format to use in the response. To
retrieve the public key in ssh-rsa format, use \code{SSH}. To retrieve the
public key in PEM format, use \code{PEM}.}
}
\description{
Retrieves the specified SSH public key, including metadata about the key.

See \url{https://www.paws-r-sdk.com/docs/iam_get_ssh_public_key/} for full documentation.
}
\keyword{internal}
