% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_policies_granting_service_access}
\alias{iam_list_policies_granting_service_access}
\title{Retrieves a list of policies that the IAM identity (user, group, or
role) can use to access each specified service}
\usage{
iam_list_policies_granting_service_access(
  Marker = NULL,
  Arn,
  ServiceNamespaces
)
}
\arguments{
\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{Arn}{[required] The ARN of the IAM identity (user, group, or role) whose policies you
want to list.}

\item{ServiceNamespaces}{[required] The service namespace for the Amazon Web Services services whose
policies you want to list.

To learn the service namespace for a service, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html}{Actions, resources, and condition keys for Amazon Web Services services}
in the \emph{IAM User Guide}. Choose the name of the service to view details
for that service. In the first paragraph, find the service prefix. For
example, \verb{(service prefix: a4b)}. For more information about service
namespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#genref-aws-service-namespaces}{Amazon Web Services service namespaces}
in the \emph{Amazon Web Services General Reference}.}
}
\description{
Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified service.

See \url{https://www.paws-r-sdk.com/docs/iam_list_policies_granting_service_access/} for full documentation.
}
\keyword{internal}
