# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudhsm_service.R
NULL

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/cloudhsm_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
#' @param TagList &#91;required&#93; One or more tags.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_add_tags_to_resource
cloudhsm_add_tags_to_resource <- function(ResourceArn, TagList) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$add_tags_to_resource_input(ResourceArn = ResourceArn, TagList = TagList)
  output <- .cloudhsm$add_tags_to_resource_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$add_tags_to_resource <- cloudhsm_add_tags_to_resource

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_create_hapg/](https://www.paws-r-sdk.com/docs/cloudhsm_create_hapg/) for full documentation.
#'
#' @param Label &#91;required&#93; The label of the new high-availability partition group.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_hapg
cloudhsm_create_hapg <- function(Label) {
  op <- new_operation(
    name = "CreateHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_hapg_input(Label = Label)
  output <- .cloudhsm$create_hapg_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_hapg <- cloudhsm_create_hapg

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_create_hsm/](https://www.paws-r-sdk.com/docs/cloudhsm_create_hsm/) for full documentation.
#'
#' @param SubnetId &#91;required&#93; The identifier of the subnet in your VPC in which to place the HSM.
#' @param SshKey &#91;required&#93; The SSH public key to install on the HSM.
#' @param EniIp The IP address to assign to the HSM's ENI.
#' 
#' If an IP address is not specified, an IP address will be randomly chosen
#' from the CIDR range of the subnet.
#' @param IamRoleArn &#91;required&#93; The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
#' ENI on your behalf.
#' @param ExternalId The external ID from `IamRoleArn`, if present.
#' @param SubscriptionType &#91;required&#93; 
#' @param ClientToken A user-defined token to ensure idempotence. Subsequent calls to this
#' operation with the same token will be ignored.
#' @param SyslogIp The IP address for the syslog monitoring server. The AWS CloudHSM
#' service only supports one syslog monitoring server.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_hsm
cloudhsm_create_hsm <- function(SubnetId, SshKey, EniIp = NULL, IamRoleArn, ExternalId = NULL, SubscriptionType, ClientToken = NULL, SyslogIp = NULL) {
  op <- new_operation(
    name = "CreateHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_hsm_input(SubnetId = SubnetId, SshKey = SshKey, EniIp = EniIp, IamRoleArn = IamRoleArn, ExternalId = ExternalId, SubscriptionType = SubscriptionType, ClientToken = ClientToken, SyslogIp = SyslogIp)
  output <- .cloudhsm$create_hsm_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_hsm <- cloudhsm_create_hsm

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_create_luna_client/](https://www.paws-r-sdk.com/docs/cloudhsm_create_luna_client/) for full documentation.
#'
#' @param Label The label for the client.
#' @param Certificate &#91;required&#93; The contents of a Base64-Encoded X.509 v3 certificate to be installed on
#' the HSMs used by this client.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_create_luna_client
cloudhsm_create_luna_client <- function(Label = NULL, Certificate) {
  op <- new_operation(
    name = "CreateLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$create_luna_client_input(Label = Label, Certificate = Certificate)
  output <- .cloudhsm$create_luna_client_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$create_luna_client <- cloudhsm_create_luna_client

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_delete_hapg/](https://www.paws-r-sdk.com/docs/cloudhsm_delete_hapg/) for full documentation.
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to delete.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_hapg
cloudhsm_delete_hapg <- function(HapgArn) {
  op <- new_operation(
    name = "DeleteHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_hapg_input(HapgArn = HapgArn)
  output <- .cloudhsm$delete_hapg_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_hapg <- cloudhsm_delete_hapg

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_delete_hsm/](https://www.paws-r-sdk.com/docs/cloudhsm_delete_hsm/) for full documentation.
#'
#' @param HsmArn &#91;required&#93; The ARN of the HSM to delete.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_hsm
cloudhsm_delete_hsm <- function(HsmArn) {
  op <- new_operation(
    name = "DeleteHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_hsm_input(HsmArn = HsmArn)
  output <- .cloudhsm$delete_hsm_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_hsm <- cloudhsm_delete_hsm

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_delete_luna_client/](https://www.paws-r-sdk.com/docs/cloudhsm_delete_luna_client/) for full documentation.
#'
#' @param ClientArn &#91;required&#93; The ARN of the client to delete.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_delete_luna_client
cloudhsm_delete_luna_client <- function(ClientArn) {
  op <- new_operation(
    name = "DeleteLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$delete_luna_client_input(ClientArn = ClientArn)
  output <- .cloudhsm$delete_luna_client_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$delete_luna_client <- cloudhsm_delete_luna_client

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_describe_hapg/](https://www.paws-r-sdk.com/docs/cloudhsm_describe_hapg/) for full documentation.
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to describe.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_hapg
cloudhsm_describe_hapg <- function(HapgArn) {
  op <- new_operation(
    name = "DescribeHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_hapg_input(HapgArn = HapgArn)
  output <- .cloudhsm$describe_hapg_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_hapg <- cloudhsm_describe_hapg

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_describe_hsm/](https://www.paws-r-sdk.com/docs/cloudhsm_describe_hsm/) for full documentation.
#'
#' @param HsmArn The ARN of the HSM. Either the `HsmArn` or the `SerialNumber` parameter
#' must be specified.
#' @param HsmSerialNumber The serial number of the HSM. Either the `HsmArn` or the
#' `HsmSerialNumber` parameter must be specified.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_hsm
cloudhsm_describe_hsm <- function(HsmArn = NULL, HsmSerialNumber = NULL) {
  op <- new_operation(
    name = "DescribeHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_hsm_input(HsmArn = HsmArn, HsmSerialNumber = HsmSerialNumber)
  output <- .cloudhsm$describe_hsm_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_hsm <- cloudhsm_describe_hsm

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_describe_luna_client/](https://www.paws-r-sdk.com/docs/cloudhsm_describe_luna_client/) for full documentation.
#'
#' @param ClientArn The ARN of the client.
#' @param CertificateFingerprint The certificate fingerprint.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_describe_luna_client
cloudhsm_describe_luna_client <- function(ClientArn = NULL, CertificateFingerprint = NULL) {
  op <- new_operation(
    name = "DescribeLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$describe_luna_client_input(ClientArn = ClientArn, CertificateFingerprint = CertificateFingerprint)
  output <- .cloudhsm$describe_luna_client_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$describe_luna_client <- cloudhsm_describe_luna_client

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_get_config/](https://www.paws-r-sdk.com/docs/cloudhsm_get_config/) for full documentation.
#'
#' @param ClientArn &#91;required&#93; The ARN of the client.
#' @param ClientVersion &#91;required&#93; The client version.
#' @param HapgList &#91;required&#93; A list of ARNs that identify the high-availability partition groups that
#' are associated with the client.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_get_config
cloudhsm_get_config <- function(ClientArn, ClientVersion, HapgList) {
  op <- new_operation(
    name = "GetConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$get_config_input(ClientArn = ClientArn, ClientVersion = ClientVersion, HapgList = HapgList)
  output <- .cloudhsm$get_config_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$get_config <- cloudhsm_get_config

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_list_available_zones/](https://www.paws-r-sdk.com/docs/cloudhsm_list_available_zones/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_available_zones
cloudhsm_list_available_zones <- function() {
  op <- new_operation(
    name = "ListAvailableZones",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_available_zones_input()
  output <- .cloudhsm$list_available_zones_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_available_zones <- cloudhsm_list_available_zones

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_list_hapgs/](https://www.paws-r-sdk.com/docs/cloudhsm_list_hapgs/) for full documentation.
#'
#' @param NextToken The `NextToken` value from a previous call to
#' [`list_hapgs`][cloudhsm_list_hapgs]. Pass null if this is the first
#' call.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_hapgs
cloudhsm_list_hapgs <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListHapgs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_hapgs_input(NextToken = NextToken)
  output <- .cloudhsm$list_hapgs_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_hapgs <- cloudhsm_list_hapgs

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_list_hsms/](https://www.paws-r-sdk.com/docs/cloudhsm_list_hsms/) for full documentation.
#'
#' @param NextToken The `NextToken` value from a previous call to
#' [`list_hsms`][cloudhsm_list_hsms]. Pass null if this is the first call.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_hsms
cloudhsm_list_hsms <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListHsms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_hsms_input(NextToken = NextToken)
  output <- .cloudhsm$list_hsms_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_hsms <- cloudhsm_list_hsms

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_list_luna_clients/](https://www.paws-r-sdk.com/docs/cloudhsm_list_luna_clients/) for full documentation.
#'
#' @param NextToken The `NextToken` value from a previous call to
#' [`list_luna_clients`][cloudhsm_list_luna_clients]. Pass null if this is
#' the first call.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_luna_clients
cloudhsm_list_luna_clients <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListLunaClients",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_luna_clients_input(NextToken = NextToken)
  output <- .cloudhsm$list_luna_clients_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_luna_clients <- cloudhsm_list_luna_clients

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudhsm_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_list_tags_for_resource
cloudhsm_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudhsm$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$list_tags_for_resource <- cloudhsm_list_tags_for_resource

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_modify_hapg/](https://www.paws-r-sdk.com/docs/cloudhsm_modify_hapg/) for full documentation.
#'
#' @param HapgArn &#91;required&#93; The ARN of the high-availability partition group to modify.
#' @param Label The new label for the high-availability partition group.
#' @param PartitionSerialList The list of partition serial numbers to make members of the
#' high-availability partition group.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_hapg
cloudhsm_modify_hapg <- function(HapgArn, Label = NULL, PartitionSerialList = NULL) {
  op <- new_operation(
    name = "ModifyHapg",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_hapg_input(HapgArn = HapgArn, Label = Label, PartitionSerialList = PartitionSerialList)
  output <- .cloudhsm$modify_hapg_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_hapg <- cloudhsm_modify_hapg

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_modify_hsm/](https://www.paws-r-sdk.com/docs/cloudhsm_modify_hsm/) for full documentation.
#'
#' @param HsmArn &#91;required&#93; The ARN of the HSM to modify.
#' @param SubnetId The new identifier of the subnet that the HSM is in. The new subnet must
#' be in the same Availability Zone as the current subnet.
#' @param EniIp The new IP address for the elastic network interface (ENI) attached to
#' the HSM.
#' 
#' If the HSM is moved to a different subnet, and an IP address is not
#' specified, an IP address will be randomly chosen from the CIDR range of
#' the new subnet.
#' @param IamRoleArn The new IAM role ARN.
#' @param ExternalId The new external ID.
#' @param SyslogIp The new IP address for the syslog monitoring server. The AWS CloudHSM
#' service only supports one syslog monitoring server.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_hsm
cloudhsm_modify_hsm <- function(HsmArn, SubnetId = NULL, EniIp = NULL, IamRoleArn = NULL, ExternalId = NULL, SyslogIp = NULL) {
  op <- new_operation(
    name = "ModifyHsm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_hsm_input(HsmArn = HsmArn, SubnetId = SubnetId, EniIp = EniIp, IamRoleArn = IamRoleArn, ExternalId = ExternalId, SyslogIp = SyslogIp)
  output <- .cloudhsm$modify_hsm_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_hsm <- cloudhsm_modify_hsm

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_modify_luna_client/](https://www.paws-r-sdk.com/docs/cloudhsm_modify_luna_client/) for full documentation.
#'
#' @param ClientArn &#91;required&#93; The ARN of the client.
#' @param Certificate &#91;required&#93; The new certificate for the client.
#'
#' @keywords internal
#'
#' @rdname cloudhsm_modify_luna_client
cloudhsm_modify_luna_client <- function(ClientArn, Certificate) {
  op <- new_operation(
    name = "ModifyLunaClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$modify_luna_client_input(ClientArn = ClientArn, Certificate = Certificate)
  output <- .cloudhsm$modify_luna_client_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$modify_luna_client <- cloudhsm_modify_luna_client

#' This is documentation for AWS CloudHSM Classic
#'
#' @description
#' This is documentation for **AWS CloudHSM Classic**. For more information, see [AWS CloudHSM Classic FAQs](https://aws.amazon.com/cloudhsm/faqs/), the AWS CloudHSM Classic User Guide, and the [AWS CloudHSM Classic API Reference](https://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudhsm_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/cloudhsm_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
#' @param TagKeyList &#91;required&#93; The tag key or keys to remove.
#' 
#' Specify only the tag key to remove (not the value). To overwrite the
#' value for an existing tag, use
#' [`add_tags_to_resource`][cloudhsm_add_tags_to_resource].
#'
#' @keywords internal
#'
#' @rdname cloudhsm_remove_tags_from_resource
cloudhsm_remove_tags_from_resource <- function(ResourceArn, TagKeyList) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudhsm$remove_tags_from_resource_input(ResourceArn = ResourceArn, TagKeyList = TagKeyList)
  output <- .cloudhsm$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .cloudhsm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudhsm$operations$remove_tags_from_resource <- cloudhsm_remove_tags_from_resource
