% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_verify}
\alias{kms_verify}
\title{Verifies a digital signature that was generated by the Sign operation}
\usage{
kms_verify(
  KeyId,
  Message,
  MessageType = NULL,
  Signature,
  SigningAlgorithm,
  GrantTokens = NULL
)
}
\arguments{
\item{KeyId}{[required] Identifies the asymmetric KMS key that will be used to verify the
signature. This must be the same KMS key that was used to generate the
signature. If you specify a different KMS key, the signature
verification fails.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{Message}{[required] Specifies the message that was signed. You can submit a raw message of
up to 4096 bytes, or a hash digest of the message. If you submit a
digest, use the \code{MessageType} parameter with a value of \code{DIGEST}.

If the message specified here is different from the message that was
signed, the signature verification fails. A message and its hash digest
are considered to be the same message.}

\item{MessageType}{Tells KMS whether the value of the \code{Message} parameter is a message or
message digest. The default value, RAW, indicates a message. To indicate
a message digest, enter \code{DIGEST}.

Use the \code{DIGEST} value only when the value of the \code{Message} parameter is
a message digest. If you use the \code{DIGEST} value with a raw message, the
security of the verification operation can be compromised.}

\item{Signature}{[required] The signature that the \code{\link[=kms_sign]{sign}} operation generated.}

\item{SigningAlgorithm}{[required] The signing algorithm that was used to sign the message. If you submit a
different algorithm, the signature verification fails.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Verifies a digital signature that was generated by the \code{\link[=kms_sign]{sign}} operation.

See \url{https://paws-r.github.io/docs/kms/verify.html} for full documentation.
}
\keyword{internal}
