% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_delete_imported_key_material}
\alias{kms_delete_imported_key_material}
\title{Deletes key material that you previously imported}
\usage{
kms_delete_imported_key_material(KeyId)
}
\arguments{
\item{KeyId}{[required] Identifies the KMS key from which you are deleting imported key
material. The \code{Origin} of the KMS key must be \code{EXTERNAL}.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\description{
Deletes key material that you previously imported. This operation makes the specified KMS key unusable. For more information about importing key material into KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing Key Material} in the \emph{Key Management Service Developer Guide}.

See \url{https://paws-r.github.io/docs/kms/delete_imported_key_material.html} for full documentation.
}
\keyword{internal}
