% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_signing_certificate}
\alias{iam_update_signing_certificate}
\title{Changes the status of the specified user signing certificate from active
to disabled, or vice versa}
\usage{
iam_update_signing_certificate(UserName = NULL, CertificateId, Status)
}
\arguments{
\item{UserName}{The name of the IAM user the signing certificate belongs to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{CertificateId}{[required] The ID of the signing certificate you want to update.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that can consist of any upper or lowercased letter or digit.}

\item{Status}{[required] The status you want to assign to the certificate. \code{Active} means that
the certificate can be used for programmatic calls to Amazon Web
Services \code{Inactive} means that the certificate cannot be used.}
}
\description{
Changes the status of the specified user signing certificate from active to disabled, or vice versa. This operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.

See \url{https://paws-r.github.io/docs/iam/update_signing_certificate.html} for full documentation.
}
\keyword{internal}
