% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_entities_for_policy}
\alias{iam_list_entities_for_policy}
\title{Lists all IAM users, groups, and roles that the specified managed policy
is attached to}
\usage{
iam_list_entities_for_policy(
  PolicyArn,
  EntityFilter = NULL,
  PathPrefix = NULL,
  PolicyUsageFilter = NULL,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy for which you want the
versions.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{EntityFilter}{The entity type to use for filtering the results.

For example, when \code{EntityFilter} is \code{Role}, only the roles that are
attached to the specified policy are returned. This parameter is
optional. If it is not included, all attached entities (users, groups,
and roles) are returned. The argument for this parameter must be one of
the valid values listed below.}

\item{PathPrefix}{The path prefix for filtering the results. This parameter is optional.
If it is not included, it defaults to a slash (/), listing all entities.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{PolicyUsageFilter}{The policy usage method to use for filtering the results.

To list only permissions policies,
set \code{PolicyUsageFilter} to \code{PermissionsPolicy}. To list only the
policies used to set permissions boundaries, set the value
to \code{PermissionsBoundary}.

This parameter is optional. If it is not included, all policies are
returned.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists all IAM users, groups, and roles that the specified managed policy is attached to.

See \url{https://paws-r.github.io/docs/iam/list_entities_for_policy.html} for full documentation.
}
\keyword{internal}
