% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_get_open_id_token_for_developer_identity}
\alias{cognitoidentity_get_open_id_token_for_developer_identity}
\title{Registers (or retrieves) a Cognito IdentityId and an OpenID Connect
token for a user authenticated by your backend authentication process}
\usage{
cognitoidentity_get_open_id_token_for_developer_identity(
  IdentityPoolId,
  IdentityId = NULL,
  Logins,
  PrincipalTags = NULL,
  TokenDuration = NULL
)
}
\arguments{
\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{IdentityId}{A unique identifier in the format REGION:GUID.}

\item{Logins}{[required] A set of optional name-value pairs that map provider names to provider
tokens. Each name-value pair represents a user from a public provider or
developer provider. If the user is from a developer provider, the
name-value pair will follow the syntax
\code{"developer_provider_name": "developer_user_identifier"}. The developer
provider is the "domain" by which Cognito will refer to your users; you
provided this domain while creating/updating the identity pool. The
developer user identifier is an identifier from your backend that
uniquely identifies a user. When you create an identity pool, you can
specify the supported logins.}

\item{PrincipalTags}{Use this operation to configure attribute mappings for custom providers.}

\item{TokenDuration}{The expiration time of the token, in seconds. You can specify a custom
expiration time for the token so that you can cache it. If you don't
provide an expiration time, the token is valid for 15 minutes. You can
exchange the token with Amazon STS for temporary AWS credentials, which
are valid for a maximum of one hour. The maximum token duration you can
set is 24 hours. You should take care in setting the expiration time for
a token, as there are significant security implications: an attacker
could use a leaked token to access your AWS resources for the token's
duration.

Please provide for a small grace period, usually no more than 5 minutes,
to account for clock skew.}
}
\description{
Registers (or retrieves) a Cognito \code{IdentityId} and an OpenID Connect token for a user authenticated by your backend authentication process. Supplying multiple logins will create an implicit linked account. You can only specify one developer provider as part of the \code{Logins} map, which is linked to the identity pool. The developer provider is the "domain" by which Cognito will refer to your users.

See \url{https://paws-r.github.io/docs/cognitoidentity/get_open_id_token_for_developer_identity.html} for full documentation.
}
\keyword{internal}
