% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_list_secrets}
\alias{secretsmanager_list_secrets}
\title{Lists all of the secrets that are stored by Secrets Manager in the AWS
account}
\usage{
secretsmanager_list_secrets(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{(Optional) Limits the number of results that you want to include in the
response. If you don\'t include this parameter, it defaults to a value
that\'s specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (isn\'t null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that Secrets Manager might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}

\item{NextToken}{(Optional) Use this parameter in a request if you receive a \code{NextToken}
response in a previous request that indicates that there\'s more output
available. In a subsequent call, set it to the value of the previous
call\'s \code{NextToken} response to indicate where the output should
continue from.}
}
\description{
Lists all of the secrets that are stored by Secrets Manager in the AWS
account. To list the versions currently stored for a specific secret,
use ListSecretVersionIds. The encrypted fields \code{SecretString} and
\code{SecretBinary} are not included in the output. To get that information,
call the GetSecretValue operation.
}
\details{
Always check the \code{NextToken} response parameter when calling any of the
\verb{List*} operations. These operations can occasionally return an empty or
shorter than expected list of results even when there are more results
available. When this happens, the \code{NextToken} response parameter
contains a value to pass to the next call to the same API to request the
next part of the list.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:ListSecrets
}

\strong{Related operations}
\itemize{
\item To list the versions attached to a secret, use ListSecretVersionIds.
}
}
\section{Request syntax}{
\preformatted{svc$list_secrets(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
# The following example shows how to list all of the secrets in your
# account.
\dontrun{svc$list_secrets()}

}
\keyword{internal}
