% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_service_last_accessed_details}
\alias{iam_get_service_last_accessed_details}
\title{Retrieves a service last accessed report that was created using the
GenerateServiceLastAccessedDetails operation}
\usage{
iam_get_service_last_accessed_details(JobId, MaxItems, Marker)
}
\arguments{
\item{JobId}{[required] The ID of the request generated by the
GenerateServiceLastAccessedDetails operation.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
Retrieves a service last accessed report that was created using the
\code{GenerateServiceLastAccessedDetails} operation. You can use the \code{JobId}
parameter in \code{GetServiceLastAccessedDetails} to retrieve the status of
your report job. When the report is complete, you can retrieve the
generated report. The report includes a list of AWS services that the
resource (user, group, role, or managed policy) can access.
}
\details{
Service last accessed data does not use other policy types when
determining whether a resource could access a service. These other
policy types include resource-based policies, access control lists, AWS
Organizations policies, IAM permissions boundaries, and AWS STS assume
role policies. It only applies permissions policy logic. For more about
the evaluation of policy types, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics}{Evaluating Policies}
in the \emph{IAM User Guide}.

For each service that the resource could access using permissions
policies, the operation returns details about the most recent access
attempt. If there was no attempt, the service is listed without details
about the most recent attempt to access the service. If the operation
fails, the \code{GetServiceLastAccessedDetails} operation returns the reason
that it failed.

The \code{GetServiceLastAccessedDetails} operation returns a list of
services. This list includes the number of entities that have attempted
to access the service and the date and time of the last attempt. It also
returns the ARN of the following entity, depending on the resource ARN
that you used to generate the report:
\itemize{
\item \strong{User} -- Returns the user ARN that you used to generate the
report
\item \strong{Group} -- Returns the ARN of the group member (user) that last
attempted to access the service
\item \strong{Role} -- Returns the role ARN that you used to generate the
report
\item \strong{Policy} -- Returns the ARN of the user or role that last used the
policy to attempt to access the service
}

By default, the list is sorted by service namespace.
}
\section{Request syntax}{
\preformatted{svc$get_service_last_accessed_details(
  JobId = "string",
  MaxItems = 123,
  Marker = "string"
)
}
}

\examples{
# The following operation gets details about the report with the job ID:
# examplef-1305-c245-eba4-71fe298bcda7
\donttest{svc$get_service_last_accessed_details(
  JobId = "examplef-1305-c245-eba4-71fe298bcda7"
)}

}
\keyword{internal}
