% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_get_rule}
\alias{waf_get_rule}
\title{This is AWS WAF Classic documentation}
\usage{
waf_get_rule(RuleId)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the Rule that you want to get. \code{RuleId} is returned by
\code{\link[=waf_create_rule]{create_rule}} and by \code{\link[=waf_list_rules]{list_rules}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Rule = list(
    RuleId = "string",
    Name = "string",
    MetricName = "string",
    Predicates = list(
      list(
        Negated = TRUE|FALSE,
        Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
        DataId = "string"
      )
    )
  )
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns the Rule that is specified by the \code{RuleId} that you included in
the \code{\link[=waf_get_rule]{get_rule}} request.
}
\section{Request syntax}{
\preformatted{svc$get_rule(
  RuleId = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the details of a rule with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$get_rule(
  RuleId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
