% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_public_key}
\alias{kms_get_public_key}
\title{Returns the public key of an asymmetric CMK}
\usage{
kms_get_public_key(KeyId, GrantTokens)
}
\arguments{
\item{KeyId}{[required] Identifies the asymmetric CMK that includes the public key.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  KeyId = "string",
  PublicKey = raw,
  CustomerMasterKeySpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1"|"SYMMETRIC_DEFAULT",
  KeyUsage = "SIGN_VERIFY"|"ENCRYPT_DECRYPT",
  EncryptionAlgorithms = list(
    "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256"
  ),
  SigningAlgorithms = list(
    "RSASSA_PSS_SHA_256"|"RSASSA_PSS_SHA_384"|"RSASSA_PSS_SHA_512"|"RSASSA_PKCS1_V1_5_SHA_256"|"RSASSA_PKCS1_V1_5_SHA_384"|"RSASSA_PKCS1_V1_5_SHA_512"|"ECDSA_SHA_256"|"ECDSA_SHA_384"|"ECDSA_SHA_512"
  )
)
}
}
\description{
Returns the public key of an asymmetric CMK. Unlike the private key of a
asymmetric CMK, which never leaves AWS KMS unencrypted, callers with
\code{kms:GetPublicKey} permission can download the public key of an
asymmetric CMK. You can share the public key to allow others to encrypt
messages and verify signatures outside of AWS KMS. For information about
symmetric and asymmetric CMKs, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using Symmetric and Asymmetric CMKs}
in the \emph{AWS Key Management Service Developer Guide}.

You do not need to download the public key. Instead, you can use the
public key within AWS KMS by calling the \code{\link[=kms_encrypt]{encrypt}},
\code{\link[=kms_re_encrypt]{re_encrypt}}, or \code{\link[=kms_verify]{verify}} operations
with the identifier of an asymmetric CMK. When you use the public key
within AWS KMS, you benefit from the authentication, authorization, and
logging that are part of every AWS KMS operation. You also reduce of
risk of encrypting data that cannot be decrypted. These features are not
effective outside of AWS KMS. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/download-public-key.html#download-public-key-considerations}{Special Considerations for Downloading Public Keys}.

To help you use the public key safely outside of AWS KMS,
\code{\link[=kms_get_public_key]{get_public_key}} returns important information
about the public key in the response, including:
\itemize{
\item \href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-CustomerMasterKeySpec}{CustomerMasterKeySpec}:
The type of key material in the public key, such as \code{RSA_4096} or
\code{ECC_NIST_P521}.
\item \href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage}{KeyUsage}:
Whether the key is used for encryption or signing.
\item \href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms}{EncryptionAlgorithms}
or
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms}{SigningAlgorithms}:
A list of the encryption algorithms or the signing algorithms for
the key.
}

Although AWS KMS cannot enforce these restrictions on external
operations, it is crucial that you use this information to prevent the
public key from being used improperly. For example, you can prevent a
public signing key from being used encrypt data, or prevent a public key
from being used with an encryption algorithm that is not supported by
AWS KMS. You can also avoid errors, such as using the wrong signing
algorithm in a verification operation.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: Yes. To perform this operation with a CMK in a
different AWS account, specify the key ARN or alias ARN in the value of
the \code{KeyId} parameter.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:GetPublicKey}
(key policy)

\strong{Related operations}: \code{\link[=kms_create_key]{create_key}}
}
\section{Request syntax}{
\preformatted{svc$get_public_key(
  KeyId = "string",
  GrantTokens = list(
    "string"
  )
)
}
}

\keyword{internal}
