% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_simulate_principal_policy}
\alias{iam_simulate_principal_policy}
\title{Simulate how a set of IAM policies attached to an IAM entity works with
a list of API operations and AWS resources to determine the policies'
effective permissions}
\usage{
iam_simulate_principal_policy(PolicySourceArn, PolicyInputList,
  PermissionsBoundaryPolicyInputList, ActionNames, ResourceArns,
  ResourcePolicy, ResourceOwner, CallerArn, ContextEntries,
  ResourceHandlingOption, MaxItems, Marker)
}
\arguments{
\item{PolicySourceArn}{[required] The Amazon Resource Name (ARN) of a user, group, or role whose policies
you want to include in the simulation. If you specify a user, group, or
role, the simulation includes all policies that are associated with that
entity. If you specify a user, the simulation also includes all policies
that are attached to any groups the user belongs to.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{PolicyInputList}{An optional list of additional policy documents to include in the
simulation. Each document is specified as a string containing the
complete, valid JSON text of an IAM policy.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\verb{\\u0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{\\u00FF})
\item The special characters tab (\verb{\\u0009}), line feed (\verb{\\u000A}), and
carriage return (\verb{\\u000D})
}}

\item{PermissionsBoundaryPolicyInputList}{The IAM permissions boundary policy to simulate. The permissions
boundary sets the maximum permissions that the entity can have. You can
input only one permissions boundary when you pass a policy to this
operation. An IAM entity can only have one permissions boundary in
effect at a time. For example, if a permissions boundary is attached to
an entity and you pass in a different permissions boundary policy using
this parameter, then the new permissions boundary policy is used for the
simulation. For more information about permissions boundaries, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html}{Permissions Boundaries for IAM Entities}
in the \emph{IAM User Guide}. The policy input is specified as a string
containing the complete, valid JSON text of a permissions boundary
policy.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\verb{\\u0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{\\u00FF})
\item The special characters tab (\verb{\\u0009}), line feed (\verb{\\u000A}), and
carriage return (\verb{\\u000D})
}}

\item{ActionNames}{[required] A list of names of API operations to evaluate in the simulation. Each
operation is evaluated for each resource. Each operation must include
the service identifier, such as \code{iam:CreateUser}.}

\item{ResourceArns}{A list of ARNs of AWS resources to include in the simulation. If this
parameter is not provided, then the value defaults to \code{*} (all
resources). Each API in the \code{ActionNames} parameter is evaluated for
each resource in this list. The simulation determines the access result
(allowed or denied) of each combination and reports it in the response.

The simulation does not automatically retrieve policies for the
specified resources. If you want to include a resource policy in the
simulation, then you must include the policy as a string in the
\code{ResourcePolicy} parameter.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{ResourcePolicy}{A resource-based policy to include in the simulation provided as a
string. Each resource in the simulation is treated as if it had this
policy attached. You can include only one resource-based policy in a
simulation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\verb{\\u0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{\\u00FF})
\item The special characters tab (\verb{\\u0009}), line feed (\verb{\\u000A}), and
carriage return (\verb{\\u000D})
}}

\item{ResourceOwner}{An AWS account ID that specifies the owner of any simulated resource
that does not identify its owner in the resource ARN. Examples of
resource ARNs include an S3 bucket or object. If \code{ResourceOwner} is
specified, it is also used as the account owner of any \code{ResourcePolicy}
included in the simulation. If the \code{ResourceOwner} parameter is not
specified, then the owner of the resources and the resource policy
defaults to the account of the identity provided in \code{CallerArn}. This
parameter is required only if you specify a resource-based policy and
account that owns the resource is different from the account that owns
the simulated calling user \code{CallerArn}.}

\item{CallerArn}{The ARN of the IAM user that you want to specify as the simulated caller
of the API operations. If you do not specify a \code{CallerArn}, it defaults
to the ARN of the user that you specify in \code{PolicySourceArn}, if you
specified a user. If you include both a \code{PolicySourceArn} (for example,
\verb{arn:aws:iam::123456789012:user/David}) and a \code{CallerArn} (for example,
\verb{arn:aws:iam::123456789012:user/Bob}), the result is that you simulate
calling the API operations as Bob, as if Bob had David's policies.

You can specify only the ARN of an IAM user. You cannot specify the ARN
of an assumed role, federated user, or a service principal.

\code{CallerArn} is required if you include a \code{ResourcePolicy} and the
\code{PolicySourceArn} is not the ARN for an IAM user. This is required so
that the resource-based policy's \code{Principal} element has a value to use
in evaluating the policy.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{ContextEntries}{A list of context keys and corresponding values for the simulation to
use. Whenever a context key is evaluated in one of the simulated IAM
permissions policies, the corresponding value is supplied.}

\item{ResourceHandlingOption}{Specifies the type of simulation to run. Different API operations that
support resource-based policies require different combinations of
resources. By specifying the type of simulation to run, you enable the
policy simulator to enforce the presence of the required resources to
ensure reliable simulation results. If your simulation does not match
one of the following scenarios, then you can omit this parameter. The
following list shows each of the supported scenario values and the
resources that you must define to run the simulation.

Each of the EC2 scenarios requires that you specify instance, image, and
security group resources. If your scenario includes an EBS volume, then
you must specify that volume as a resource. If the EC2 scenario includes
VPC, then you must supply the network interface resource. If it includes
an IP subnet, then you must specify the subnet resource. For more
information on the EC2 scenario options, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html}{Supported Platforms}
in the \emph{Amazon EC2 User Guide}.
\itemize{
\item \strong{EC2-Classic-InstanceStore}

instance, image, security group
\item \strong{EC2-Classic-EBS}

instance, image, security group, volume
\item \strong{EC2-VPC-InstanceStore}

instance, image, security group, network interface
\item \strong{EC2-VPC-InstanceStore-Subnet}

instance, image, security group, network interface, subnet
\item \strong{EC2-VPC-EBS}

instance, image, security group, network interface, volume
\item \strong{EC2-VPC-EBS-Subnet}

instance, image, security group, network interface, subnet, volume
}}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\value{
A list with the following syntax:\preformatted{list(
  EvaluationResults = list(
    list(
      EvalActionName = "string",
      EvalResourceName = "string",
      EvalDecision = "allowed"|"explicitDeny"|"implicitDeny",
      MatchedStatements = list(
        list(
          SourcePolicyId = "string",
          SourcePolicyType = "user"|"group"|"role"|"aws-managed"|"user-managed"|"resource"|"none",
          StartPosition = list(
            Line = 123,
            Column = 123
          ),
          EndPosition = list(
            Line = 123,
            Column = 123
          )
        )
      ),
      MissingContextValues = list(
        "string"
      ),
      OrganizationsDecisionDetail = list(
        AllowedByOrganizations = TRUE|FALSE
      ),
      PermissionsBoundaryDecisionDetail = list(
        AllowedByPermissionsBoundary = TRUE|FALSE
      ),
      EvalDecisionDetails = list(
        "allowed"|"explicitDeny"|"implicitDeny"
      ),
      ResourceSpecificResults = list(
        list(
          EvalResourceName = "string",
          EvalResourceDecision = "allowed"|"explicitDeny"|"implicitDeny",
          MatchedStatements = list(
            list(
              SourcePolicyId = "string",
              SourcePolicyType = "user"|"group"|"role"|"aws-managed"|"user-managed"|"resource"|"none",
              StartPosition = list(
                Line = 123,
                Column = 123
              ),
              EndPosition = list(
                Line = 123,
                Column = 123
              )
            )
          ),
          MissingContextValues = list(
            "string"
          ),
          EvalDecisionDetails = list(
            "allowed"|"explicitDeny"|"implicitDeny"
          ),
          PermissionsBoundaryDecisionDetail = list(
            AllowedByPermissionsBoundary = TRUE|FALSE
          )
        )
      )
    )
  ),
  IsTruncated = TRUE|FALSE,
  Marker = "string"
)
}
}
\description{
Simulate how a set of IAM policies attached to an IAM entity works with
a list of API operations and AWS resources to determine the policies'
effective permissions. The entity can be an IAM user, group, or role. If
you specify a user, then the simulation also includes all of the
policies that are attached to groups that the user belongs to.

You can optionally include a list of one or more additional policies
specified as strings to include in the simulation. If you want to
simulate only policies specified as strings, use
\code{\link[=iam_simulate_custom_policy]{simulate_custom_policy}} instead.

You can also optionally include one resource-based policy to be
evaluated with each of the resources included in the simulation.

The simulation does not perform the API operations; it only checks the
authorization to determine if the simulated policies allow or deny the
operations.

\strong{Note:} This API discloses information about the permissions granted
to other users. If you do not want users to see other user's
permissions, then consider allowing them to use
\code{\link[=iam_simulate_custom_policy]{simulate_custom_policy}} instead.

Context keys are variables maintained by AWS and its services that
provide details about the context of an API query request. You can use
the \code{Condition} element of an IAM policy to evaluate context keys. To
get the list of context keys that the policies require for correct
simulation, use
\code{\link[=iam_get_context_keys_for_principal_policy]{get_context_keys_for_principal_policy}}.

If the output is long, you can use the \code{MaxItems} and \code{Marker}
parameters to paginate the results.
}
\section{Request syntax}{
\preformatted{svc$simulate_principal_policy(
  PolicySourceArn = "string",
  PolicyInputList = list(
    "string"
  ),
  PermissionsBoundaryPolicyInputList = list(
    "string"
  ),
  ActionNames = list(
    "string"
  ),
  ResourceArns = list(
    "string"
  ),
  ResourcePolicy = "string",
  ResourceOwner = "string",
  CallerArn = "string",
  ContextEntries = list(
    list(
      ContextKeyName = "string",
      ContextKeyValues = list(
        "string"
      ),
      ContextKeyType = "string"|"stringList"|"numeric"|"numericList"|"boolean"|"booleanList"|"ip"|"ipList"|"binary"|"binaryList"|"date"|"dateList"
    )
  ),
  ResourceHandlingOption = "string",
  MaxItems = 123,
  Marker = "string"
)
}
}

\keyword{internal}
