% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_findings}
\alias{guardduty_get_findings}
\title{Describes Amazon GuardDuty findings specified by finding IDs}
\usage{
guardduty_get_findings(DetectorId, FindingIds, SortCriteria)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector that specifies the GuardDuty service whose
findings you want to retrieve.}

\item{FindingIds}{[required] The IDs of the findings that you want to retrieve.}

\item{SortCriteria}{Represents the criteria used for sorting findings.}
}
\value{
A list with the following syntax:\preformatted{list(
  Findings = list(
    list(
      AccountId = "string",
      Arn = "string",
      Confidence = 123.0,
      CreatedAt = "string",
      Description = "string",
      Id = "string",
      Partition = "string",
      Region = "string",
      Resource = list(
        AccessKeyDetails = list(
          AccessKeyId = "string",
          PrincipalId = "string",
          UserName = "string",
          UserType = "string"
        ),
        S3BucketDetails = list(
          list(
            Arn = "string",
            Name = "string",
            Type = "string",
            CreatedAt = as.POSIXct(
              "2015-01-01"
            ),
            Owner = list(
              Id = "string"
            ),
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            ),
            DefaultServerSideEncryption = list(
              EncryptionType = "string",
              KmsMasterKeyArn = "string"
            ),
            PublicAccess = list(
              PermissionConfiguration = list(
                BucketLevelPermissions = list(
                  AccessControlList = list(
                    AllowsPublicReadAccess = TRUE|FALSE,
                    AllowsPublicWriteAccess = TRUE|FALSE
                  ),
                  BucketPolicy = list(
                    AllowsPublicReadAccess = TRUE|FALSE,
                    AllowsPublicWriteAccess = TRUE|FALSE
                  ),
                  BlockPublicAccess = list(
                    IgnorePublicAcls = TRUE|FALSE,
                    RestrictPublicBuckets = TRUE|FALSE,
                    BlockPublicAcls = TRUE|FALSE,
                    BlockPublicPolicy = TRUE|FALSE
                  )
                ),
                AccountLevelPermissions = list(
                  BlockPublicAccess = list(
                    IgnorePublicAcls = TRUE|FALSE,
                    RestrictPublicBuckets = TRUE|FALSE,
                    BlockPublicAcls = TRUE|FALSE,
                    BlockPublicPolicy = TRUE|FALSE
                  )
                )
              ),
              EffectivePermission = "string"
            )
          )
        ),
        InstanceDetails = list(
          AvailabilityZone = "string",
          IamInstanceProfile = list(
            Arn = "string",
            Id = "string"
          ),
          ImageDescription = "string",
          ImageId = "string",
          InstanceId = "string",
          InstanceState = "string",
          InstanceType = "string",
          OutpostArn = "string",
          LaunchTime = "string",
          NetworkInterfaces = list(
            list(
              Ipv6Addresses = list(
                "string"
              ),
              NetworkInterfaceId = "string",
              PrivateDnsName = "string",
              PrivateIpAddress = "string",
              PrivateIpAddresses = list(
                list(
                  PrivateDnsName = "string",
                  PrivateIpAddress = "string"
                )
              ),
              PublicDnsName = "string",
              PublicIp = "string",
              SecurityGroups = list(
                list(
                  GroupId = "string",
                  GroupName = "string"
                )
              ),
              SubnetId = "string",
              VpcId = "string"
            )
          ),
          Platform = "string",
          ProductCodes = list(
            list(
              Code = "string",
              ProductType = "string"
            )
          ),
          Tags = list(
            list(
              Key = "string",
              Value = "string"
            )
          )
        ),
        ResourceType = "string"
      ),
      SchemaVersion = "string",
      Service = list(
        Action = list(
          ActionType = "string",
          AwsApiCallAction = list(
            Api = "string",
            CallerType = "string",
            DomainDetails = list(
              Domain = "string"
            ),
            ErrorCode = "string",
            RemoteIpDetails = list(
              City = list(
                CityName = "string"
              ),
              Country = list(
                CountryCode = "string",
                CountryName = "string"
              ),
              GeoLocation = list(
                Lat = 123.0,
                Lon = 123.0
              ),
              IpAddressV4 = "string",
              Organization = list(
                Asn = "string",
                AsnOrg = "string",
                Isp = "string",
                Org = "string"
              )
            ),
            ServiceName = "string"
          ),
          DnsRequestAction = list(
            Domain = "string"
          ),
          NetworkConnectionAction = list(
            Blocked = TRUE|FALSE,
            ConnectionDirection = "string",
            LocalPortDetails = list(
              Port = 123,
              PortName = "string"
            ),
            Protocol = "string",
            LocalIpDetails = list(
              IpAddressV4 = "string"
            ),
            RemoteIpDetails = list(
              City = list(
                CityName = "string"
              ),
              Country = list(
                CountryCode = "string",
                CountryName = "string"
              ),
              GeoLocation = list(
                Lat = 123.0,
                Lon = 123.0
              ),
              IpAddressV4 = "string",
              Organization = list(
                Asn = "string",
                AsnOrg = "string",
                Isp = "string",
                Org = "string"
              )
            ),
            RemotePortDetails = list(
              Port = 123,
              PortName = "string"
            )
          ),
          PortProbeAction = list(
            Blocked = TRUE|FALSE,
            PortProbeDetails = list(
              list(
                LocalPortDetails = list(
                  Port = 123,
                  PortName = "string"
                ),
                LocalIpDetails = list(
                  IpAddressV4 = "string"
                ),
                RemoteIpDetails = list(
                  City = list(
                    CityName = "string"
                  ),
                  Country = list(
                    CountryCode = "string",
                    CountryName = "string"
                  ),
                  GeoLocation = list(
                    Lat = 123.0,
                    Lon = 123.0
                  ),
                  IpAddressV4 = "string",
                  Organization = list(
                    Asn = "string",
                    AsnOrg = "string",
                    Isp = "string",
                    Org = "string"
                  )
                )
              )
            )
          )
        ),
        Evidence = list(
          ThreatIntelligenceDetails = list(
            list(
              ThreatListName = "string",
              ThreatNames = list(
                "string"
              )
            )
          )
        ),
        Archived = TRUE|FALSE,
        Count = 123,
        DetectorId = "string",
        EventFirstSeen = "string",
        EventLastSeen = "string",
        ResourceRole = "string",
        ServiceName = "string",
        UserFeedback = "string"
      ),
      Severity = 123.0,
      Title = "string",
      Type = "string",
      UpdatedAt = "string"
    )
  )
)
}
}
\description{
Describes Amazon GuardDuty findings specified by finding IDs.
}
\section{Request syntax}{
\preformatted{svc$get_findings(
  DetectorId = "string",
  FindingIds = list(
    "string"
  ),
  SortCriteria = list(
    AttributeName = "string",
    OrderBy = "ASC"|"DESC"
  )
)
}
}

\keyword{internal}
