% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_snapshots}
\alias{directoryservice_describe_snapshots}
\title{Obtains information about the directory snapshots that belong to this
account}
\usage{
directoryservice_describe_snapshots(DirectoryId, SnapshotIds, NextToken,
  Limit)
}
\arguments{
\item{DirectoryId}{The identifier of the directory for which to retrieve snapshot
information.}

\item{SnapshotIds}{A list of identifiers of the snapshots to obtain the information for. If
this member is null or empty, all snapshots are returned using the
\emph{Limit} and \emph{NextToken} members.}

\item{NextToken}{The \emph{DescribeSnapshotsResult.NextToken} value from a previous call to
\code{\link[=directoryservice_describe_snapshots]{describe_snapshots}}. Pass null
if this is the first call.}

\item{Limit}{The maximum number of objects to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Snapshots = list(
    list(
      DirectoryId = "string",
      SnapshotId = "string",
      Type = "Auto"|"Manual",
      Name = "string",
      Status = "Creating"|"Completed"|"Failed",
      StartTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Obtains information about the directory snapshots that belong to this
account.

This operation supports pagination with the use of the \emph{NextToken}
request and response parameters. If more results are available, the
\emph{DescribeSnapshots.NextToken} member contains a token that you pass in
the next call to
\code{\link[=directoryservice_describe_snapshots]{describe_snapshots}} to retrieve
the next set of items.

You can also specify a maximum number of return results with the \emph{Limit}
parameter.
}
\section{Request syntax}{
\preformatted{svc$describe_snapshots(
  DirectoryId = "string",
  SnapshotIds = list(
    "string"
  ),
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
