% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_list_certificates}
\alias{acm_list_certificates}
\title{Retrieves a list of certificate ARNs and domain names}
\usage{
acm_list_certificates(CertificateStatuses, Includes, NextToken,
  MaxItems)
}
\arguments{
\item{CertificateStatuses}{Filter the certificate list by status value.}

\item{Includes}{Filter the certificate list. For more information, see the Filters
structure.}

\item{NextToken}{Use this parameter only when paginating results and only in a subsequent
request after you receive a response with truncated results. Set it to
the value of \code{NextToken} from the response you just received.}

\item{MaxItems}{Use this parameter when paginating results to specify the maximum number
of items to return in the response. If additional items exist beyond the
number you specify, the \code{NextToken} element is sent in the response. Use
this \code{NextToken} value in a subsequent request to retrieve additional
items.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  CertificateSummaryList = list(
    list(
      CertificateArn = "string",
      DomainName = "string"
    )
  )
)
}
}
\description{
Retrieves a list of certificate ARNs and domain names. You can request
that only certificates that match a specific status be listed. You can
also filter by specific attributes of the certificate. Default filtering
returns only \code{RSA_2048} certificates. For more information, see Filters.
}
\section{Request syntax}{
\preformatted{svc$list_certificates(
  CertificateStatuses = list(
    "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED"
  ),
  Includes = list(
    extendedKeyUsage = list(
      "TLS_WEB_SERVER_AUTHENTICATION"|"TLS_WEB_CLIENT_AUTHENTICATION"|"CODE_SIGNING"|"EMAIL_PROTECTION"|"TIME_STAMPING"|"OCSP_SIGNING"|"IPSEC_END_SYSTEM"|"IPSEC_TUNNEL"|"IPSEC_USER"|"ANY"|"NONE"|"CUSTOM"
    ),
    keyUsage = list(
      "DIGITAL_SIGNATURE"|"NON_REPUDIATION"|"KEY_ENCIPHERMENT"|"DATA_ENCIPHERMENT"|"KEY_AGREEMENT"|"CERTIFICATE_SIGNING"|"CRL_SIGNING"|"ENCIPHER_ONLY"|"DECIPHER_ONLY"|"ANY"|"CUSTOM"
    ),
    keyTypes = list(
      "RSA_2048"|"RSA_1024"|"RSA_4096"|"EC_prime256v1"|"EC_secp384r1"|"EC_secp521r1"
    )
  ),
  NextToken = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
