% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_key_policy}
\alias{kms_get_key_policy}
\title{Gets a key policy attached to the specified customer master key (CMK)}
\usage{
kms_get_key_policy(KeyId, PolicyName)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{PolicyName}{[required] Specifies the name of the key policy. The only valid name is \code{default}.
To get the names of key policies, use
\code{\link[=kms_list_key_policies]{list_key_policies}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Policy = "string"
)
}
}
\description{
Gets a key policy attached to the specified customer master key (CMK).

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:GetKeyPolicy}
(key policy)

\strong{Related operations}: \code{\link[=kms_put_key_policy]{put_key_policy}}
}
\section{Request syntax}{
\preformatted{svc$get_key_policy(
  KeyId = "string",
  PolicyName = "string"
)
}
}

\examples{
\dontrun{
# The following example retrieves the key policy for the specified
# customer master key (CMK).
svc$get_key_policy(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  PolicyName = "default"
)
}

}
\keyword{internal}
