% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_list_user_pools}
\alias{cognitoidentityprovider_list_user_pools}
\title{Lists the user pools associated with an AWS account}
\usage{
cognitoidentityprovider_list_user_pools(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{An identifier that was returned from the previous call to this
operation, which can be used to return the next set of items in the
list.}

\item{MaxResults}{[required] The maximum number of results you want the request to return when
listing the user pools.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserPools = list(
    list(
      Id = "string",
      Name = "string",
      LambdaConfig = list(
        PreSignUp = "string",
        CustomMessage = "string",
        PostConfirmation = "string",
        PreAuthentication = "string",
        PostAuthentication = "string",
        DefineAuthChallenge = "string",
        CreateAuthChallenge = "string",
        VerifyAuthChallengeResponse = "string",
        PreTokenGeneration = "string",
        UserMigration = "string",
        CustomSMSSender = list(
          LambdaVersion = "V1_0",
          LambdaArn = "string"
        ),
        CustomEmailSender = list(
          LambdaVersion = "V1_0",
          LambdaArn = "string"
        ),
        KMSKeyID = "string"
      ),
      Status = "Enabled"|"Disabled",
      LastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      CreationDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the user pools associated with an AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_user_pools(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
