% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_service.R
\name{wafregional}
\alias{wafregional}
\title{AWS WAF Regional}
\usage{
wafregional(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
This is \strong{AWS WAF Classic Regional} documentation. For more
information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

This is the \emph{AWS WAF Regional Classic API Reference} for using AWS WAF
Classic with the AWS resources, Elastic Load Balancing (ELB) Application
Load Balancers and API Gateway APIs. The AWS WAF Classic actions and
data types listed in the reference are available for protecting Elastic
Load Balancing (ELB) Application Load Balancers and API Gateway APIs.
You can use these actions and data types by means of the endpoints
listed in \href{https://docs.aws.amazon.com/general/latest/gr/rande.html#waf_region}{AWS Regions and Endpoints}.
This guide is for developers who need detailed information about the AWS
WAF Classic API actions, data types, and errors. For detailed
information about AWS WAF Classic features and an overview of how to use
the AWS WAF Classic API, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\section{Service syntax}{
\preformatted{svc <- wafregional(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=wafregional_associate_web_acl]{associate_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
\link[=wafregional_create_byte_match_set]{create_byte_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_geo_match_set]{create_geo_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_ip_set]{create_ip_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_rate_based_rule]{create_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_regex_match_set]{create_regex_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_regex_pattern_set]{create_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_rule]{create_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_rule_group]{create_rule_group} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_size_constraint_set]{create_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_sql_injection_match_set]{create_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_web_acl]{create_web_acl} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_create_web_acl_migration_stack]{create_web_acl_migration_stack} \tab Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket\cr
\link[=wafregional_create_xss_match_set]{create_xss_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_byte_match_set]{delete_byte_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_geo_match_set]{delete_geo_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_ip_set]{delete_ip_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_logging_configuration]{delete_logging_configuration} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_permission_policy]{delete_permission_policy} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_rate_based_rule]{delete_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_regex_match_set]{delete_regex_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_regex_pattern_set]{delete_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_rule]{delete_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_rule_group]{delete_rule_group} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_size_constraint_set]{delete_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_sql_injection_match_set]{delete_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_web_acl]{delete_web_acl} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_delete_xss_match_set]{delete_xss_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_disassociate_web_acl]{disassociate_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
\link[=wafregional_get_byte_match_set]{get_byte_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_change_token]{get_change_token} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_change_token_status]{get_change_token_status} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_geo_match_set]{get_geo_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_ip_set]{get_ip_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_logging_configuration]{get_logging_configuration} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_permission_policy]{get_permission_policy} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_rate_based_rule]{get_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_rate_based_rule_managed_keys]{get_rate_based_rule_managed_keys} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_regex_match_set]{get_regex_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_regex_pattern_set]{get_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_rule]{get_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_rule_group]{get_rule_group} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_sampled_requests]{get_sampled_requests} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_size_constraint_set]{get_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_sql_injection_match_set]{get_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_web_acl]{get_web_acl} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_get_web_acl_for_resource]{get_web_acl_for_resource} \tab This is AWS WAF Classic Regional documentation\cr
\link[=wafregional_get_xss_match_set]{get_xss_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_activated_rules_in_rule_group]{list_activated_rules_in_rule_group} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_byte_match_sets]{list_byte_match_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_geo_match_sets]{list_geo_match_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_ip_sets]{list_ip_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_logging_configurations]{list_logging_configurations} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_rate_based_rules]{list_rate_based_rules} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_regex_match_sets]{list_regex_match_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_regex_pattern_sets]{list_regex_pattern_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_resources_for_web_acl]{list_resources_for_web_acl} \tab This is AWS WAF Classic Regional documentation\cr
\link[=wafregional_list_rule_groups]{list_rule_groups} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_rules]{list_rules} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_size_constraint_sets]{list_size_constraint_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_sql_injection_match_sets]{list_sql_injection_match_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_subscribed_rule_groups]{list_subscribed_rule_groups} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_tags_for_resource]{list_tags_for_resource} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_web_ac_ls]{list_web_ac_ls} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_list_xss_match_sets]{list_xss_match_sets} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_put_logging_configuration]{put_logging_configuration} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_put_permission_policy]{put_permission_policy} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_tag_resource]{tag_resource} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_untag_resource]{untag_resource} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_byte_match_set]{update_byte_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_geo_match_set]{update_geo_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_ip_set]{update_ip_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_rate_based_rule]{update_rate_based_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_regex_match_set]{update_regex_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_regex_pattern_set]{update_regex_pattern_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_rule]{update_rule} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_rule_group]{update_rule_group} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_size_constraint_set]{update_size_constraint_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_sql_injection_match_set]{update_sql_injection_match_set} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_web_acl]{update_web_acl} \tab This is AWS WAF Classic documentation\cr
\link[=wafregional_update_xss_match_set]{update_xss_match_set} \tab This is AWS WAF Classic documentation
}
}

\examples{
\dontrun{
svc <- wafregional()
# The following example creates an IP match set named MyIPSetFriendlyName.
svc$create_ip_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MyIPSetFriendlyName"
)
}

}
