% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_untag_resource}
\alias{kms_untag_resource}
\title{Deletes tags from a customer managed CMK}
\usage{
kms_untag_resource(KeyId, TagKeys)
}
\arguments{
\item{KeyId}{[required] Identifies the CMK from which you are removing tags.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{TagKeys}{[required] One or more tag keys. Specify only the tag keys, not the tag values.}
}
\description{
Deletes tags from a \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed CMK}.
To delete a tag, specify the tag key and the CMK.

When it succeeds, the \code{UntagResource} operation doesn't return any
output. Also, if the specified tag key isn't found on the CMK, it
doesn't throw an exception or return a response. To confirm that the
operation worked, use the ListResourceTags operation.

For general information about tags, including the format and syntax, see
\href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS resources}
in the \emph{Amazon Web Services General Reference}. For information about
using tags in AWS KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html}{Tagging keys}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:UntagResource}
(key policy)

\strong{Related operations}
\itemize{
\item TagResource
\item ListResourceTags
}
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  KeyId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example removes tags from a CMK.
svc$untag_resource(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  TagKeys = list(
    "Purpose",
    "CostCenter"
  )
)
}

}
\keyword{internal}
