% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_group}
\alias{iam_create_group}
\title{Creates a new group}
\usage{
iam_create_group(Path, GroupName)
}
\arguments{
\item{Path}{The path to the group. For more information about paths, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{GroupName}{[required] The name of the group to create. Do not include the path in this value.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both "MyResource" and "myresource".}
}
\description{
Creates a new group.

The number and size of IAM resources in an AWS account are limited. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html}{IAM and STS Quotas}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_group(
  Path = "string",
  GroupName = "string"
)
}
}

\examples{
\dontrun{
# The following command creates an IAM group named Admins.
svc$create_group(
  GroupName = "Admins"
)
}

}
\keyword{internal}
