% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_list_certificate_authorities}
\alias{acmpca_list_certificate_authorities}
\title{Lists the private certificate authorities that you created by using the
CreateCertificateAuthority action}
\usage{
acmpca_list_certificate_authorities(NextToken, MaxResults,
  ResourceOwner)
}
\arguments{
\item{NextToken}{Use this parameter when paginating results in a subsequent request after
you receive a response with truncated results. Set it to the value of
the \code{NextToken} parameter from the response you just received.}

\item{MaxResults}{Use this parameter when paginating results to specify the maximum number
of items to return in the response on each page. If additional items
exist beyond the number you specify, the \code{NextToken} element is sent in
the response. Use this \code{NextToken} value in a subsequent request to
retrieve additional items.}

\item{ResourceOwner}{Use this parameter to filter the returned set of certificate authorities
based on their owner. The default is SELF.}
}
\description{
Lists the private certificate authorities that you created by using the
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html}{CreateCertificateAuthority}
action.
}
\section{Request syntax}{
\preformatted{svc$list_certificate_authorities(
  NextToken = "string",
  MaxResults = 123,
  ResourceOwner = "SELF"|"OTHER_ACCOUNTS"
)
}
}

\keyword{internal}
