# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Telco Network Builder
#'
#' @description
#' Amazon Web Services Telco Network Builder (TNB) is a network automation
#' service that helps you deploy and manage telecom networks. AWS TNB helps
#' you with the lifecycle management of your telecommunication network
#' functions throughout planning, deployment, and post-deployment
#' activities.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- telconetworkbuilder(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- telconetworkbuilder()
#' svc$cancel_sol_network_operation(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=telconetworkbuilder_cancel_sol_network_operation]{cancel_sol_network_operation} \tab Cancels a network operation\cr
#'  \link[=telconetworkbuilder_create_sol_function_package]{create_sol_function_package} \tab Creates a function package\cr
#'  \link[=telconetworkbuilder_create_sol_network_instance]{create_sol_network_instance} \tab Creates a network instance\cr
#'  \link[=telconetworkbuilder_create_sol_network_package]{create_sol_network_package} \tab Creates a network package\cr
#'  \link[=telconetworkbuilder_delete_sol_function_package]{delete_sol_function_package} \tab Deletes a function package\cr
#'  \link[=telconetworkbuilder_delete_sol_network_instance]{delete_sol_network_instance} \tab Deletes a network instance\cr
#'  \link[=telconetworkbuilder_delete_sol_network_package]{delete_sol_network_package} \tab Deletes network package\cr
#'  \link[=telconetworkbuilder_get_sol_function_instance]{get_sol_function_instance} \tab Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package\cr
#'  \link[=telconetworkbuilder_get_sol_function_package]{get_sol_function_package} \tab Gets the details of an individual function package, such as the operational state and whether the package is in use\cr
#'  \link[=telconetworkbuilder_get_sol_function_package_content]{get_sol_function_package_content} \tab Gets the contents of a function package\cr
#'  \link[=telconetworkbuilder_get_sol_function_package_descriptor]{get_sol_function_package_descriptor} \tab Gets a function package descriptor in a function package\cr
#'  \link[=telconetworkbuilder_get_sol_network_instance]{get_sol_network_instance} \tab Gets the details of the network instance\cr
#'  \link[=telconetworkbuilder_get_sol_network_operation]{get_sol_network_operation} \tab Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks\cr
#'  \link[=telconetworkbuilder_get_sol_network_package]{get_sol_network_package} \tab Gets the details of a network package\cr
#'  \link[=telconetworkbuilder_get_sol_network_package_content]{get_sol_network_package_content} \tab Gets the contents of a network package\cr
#'  \link[=telconetworkbuilder_get_sol_network_package_descriptor]{get_sol_network_package_descriptor} \tab Gets the content of the network service descriptor\cr
#'  \link[=telconetworkbuilder_instantiate_sol_network_instance]{instantiate_sol_network_instance} \tab Instantiates a network instance\cr
#'  \link[=telconetworkbuilder_list_sol_function_instances]{list_sol_function_instances} \tab Lists network function instances\cr
#'  \link[=telconetworkbuilder_list_sol_function_packages]{list_sol_function_packages} \tab Lists information about function packages\cr
#'  \link[=telconetworkbuilder_list_sol_network_instances]{list_sol_network_instances} \tab Lists your network instances\cr
#'  \link[=telconetworkbuilder_list_sol_network_operations]{list_sol_network_operations} \tab Lists details for a network operation, including when the operation started and the status of the operation\cr
#'  \link[=telconetworkbuilder_list_sol_network_packages]{list_sol_network_packages} \tab Lists network packages\cr
#'  \link[=telconetworkbuilder_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for AWS TNB resources\cr
#'  \link[=telconetworkbuilder_put_sol_function_package_content]{put_sol_function_package_content} \tab Uploads the contents of a function package\cr
#'  \link[=telconetworkbuilder_put_sol_network_package_content]{put_sol_network_package_content} \tab Uploads the contents of a network package\cr
#'  \link[=telconetworkbuilder_tag_resource]{tag_resource} \tab Tags an AWS TNB resource\cr
#'  \link[=telconetworkbuilder_terminate_sol_network_instance]{terminate_sol_network_instance} \tab Terminates a network instance\cr
#'  \link[=telconetworkbuilder_untag_resource]{untag_resource} \tab Untags an AWS TNB resource\cr
#'  \link[=telconetworkbuilder_update_sol_function_package]{update_sol_function_package} \tab Updates the operational state of function package\cr
#'  \link[=telconetworkbuilder_update_sol_network_instance]{update_sol_network_instance} \tab Update a network instance\cr
#'  \link[=telconetworkbuilder_update_sol_network_package]{update_sol_network_package} \tab Updates the operational state of a network package\cr
#'  \link[=telconetworkbuilder_validate_sol_function_package_content]{validate_sol_function_package_content} \tab Validates function package content\cr
#'  \link[=telconetworkbuilder_validate_sol_network_package_content]{validate_sol_network_package_content} \tab Validates network package content
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname telconetworkbuilder
#' @export
telconetworkbuilder <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .telconetworkbuilder$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.telconetworkbuilder <- list()

.telconetworkbuilder$operations <- list()

.telconetworkbuilder$metadata <- list(
  service_name = "telconetworkbuilder",
  endpoints = list("*" = list(endpoint = "tnb.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "tnb.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "tnb.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "tnb.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "tnb.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "tnb.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "tnb",
  api_version = "2008-10-21",
  signing_name = "tnb",
  json_version = "1.1",
  target_prefix = ""
)

.telconetworkbuilder$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.telconetworkbuilder$metadata, handlers, config, op)
}
