% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_get_network_resources}
\alias{networkmanager_get_network_resources}
\title{Describes the network resources for the specified global network}
\usage{
networkmanager_get_network_resources(
  GlobalNetworkId,
  CoreNetworkId = NULL,
  RegisteredGatewayArn = NULL,
  AwsRegion = NULL,
  AccountId = NULL,
  ResourceType = NULL,
  ResourceArn = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{CoreNetworkId}{The ID of a core network.}

\item{RegisteredGatewayArn}{The ARN of the gateway.}

\item{AwsRegion}{The Amazon Web Services Region.}

\item{AccountId}{The Amazon Web Services account ID.}

\item{ResourceType}{The resource type.

The following are the supported resource types for Direct Connect:
\itemize{
\item \code{dxcon} - The definition model is
\href{https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html}{Connection}.
\item \code{dx-gateway} - The definition model is
\href{https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html}{DirectConnectGateway}.
\item \code{dx-vif} - The definition model is
\href{https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html}{VirtualInterface}.
}

The following are the supported resource types for Network Manager:
\itemize{
\item \code{connection} - The definition model is
\href{https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html}{Connection}.
\item \code{device} - The definition model is
\href{https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html}{Device}.
\item \code{link} - The definition model is
\href{https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html}{Link}.
\item \code{site} - The definition model is
\href{https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html}{Site}.
}

The following are the supported resource types for Amazon VPC:
\itemize{
\item \code{customer-gateway} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html}{CustomerGateway}.
\item \code{transit-gateway} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html}{TransitGateway}.
\item \code{transit-gateway-attachment} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html}{TransitGatewayAttachment}.
\item \code{transit-gateway-connect-peer} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html}{TransitGatewayConnectPeer}.
\item \code{transit-gateway-route-table} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html}{TransitGatewayRouteTable}.
\item \code{vpn-connection} - The definition model is
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html}{VpnConnection}.
}}

\item{ResourceArn}{The ARN of the resource.}

\item{MaxResults}{The maximum number of results to return.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes the network resources for the specified global network.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_get_network_resources/} for full documentation.
}
\keyword{internal}
