# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include networkfirewall_service.R
NULL

#' Associates a FirewallPolicy to a Firewall
#'
#' @description
#' Associates a FirewallPolicy to a Firewall.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_associate_firewall_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_associate_firewall_policy/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the firewall policy.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_associate_firewall_policy
networkfirewall_associate_firewall_policy <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, FirewallPolicyArn) {
  op <- new_operation(
    name = "AssociateFirewallPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$associate_firewall_policy_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, FirewallPolicyArn = FirewallPolicyArn)
  output <- .networkfirewall$associate_firewall_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$associate_firewall_policy <- networkfirewall_associate_firewall_policy

#' Associates the specified subnets in the Amazon VPC to the firewall
#'
#' @description
#' Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_associate_subnets/](https://www.paws-r-sdk.com/docs/networkfirewall_associate_subnets/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param SubnetMappings &#91;required&#93; The IDs of the subnets that you want to associate with the firewall.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_associate_subnets
networkfirewall_associate_subnets <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, SubnetMappings) {
  op <- new_operation(
    name = "AssociateSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$associate_subnets_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, SubnetMappings = SubnetMappings)
  output <- .networkfirewall$associate_subnets_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$associate_subnets <- networkfirewall_associate_subnets

#' Creates an Network Firewall Firewall and accompanying FirewallStatus for
#' a VPC
#'
#' @description
#' Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_create_firewall/](https://www.paws-r-sdk.com/docs/networkfirewall_create_firewall/) for full documentation.
#'
#' @param FirewallName &#91;required&#93; The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' @param FirewallPolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the FirewallPolicy that you want to
#' use for the firewall.
#' @param VpcId &#91;required&#93; The unique identifier of the VPC where Network Firewall should create
#' the firewall.
#' 
#' You can't change this setting after you create the firewall.
#' @param SubnetMappings &#91;required&#93; The public subnets to use for your Network Firewall firewalls. Each
#' subnet must belong to a different Availability Zone in the VPC. Network
#' Firewall creates a firewall endpoint in each subnet.
#' @param DeleteProtection A flag indicating whether it is possible to delete the firewall. A
#' setting of `TRUE` indicates that the firewall is protected against
#' deletion. Use this setting to protect against accidentally deleting a
#' firewall that is in use. When you create a firewall, the operation
#' initializes this flag to `TRUE`.
#' @param SubnetChangeProtection A setting indicating whether the firewall is protected against changes
#' to the subnet associations. Use this setting to protect against
#' accidentally modifying the subnet associations for a firewall that is in
#' use. When you create a firewall, the operation initializes this setting
#' to `TRUE`.
#' @param FirewallPolicyChangeProtection A setting indicating whether the firewall is protected against a change
#' to the firewall policy association. Use this setting to protect against
#' accidentally modifying the firewall policy for a firewall that is in
#' use. When you create a firewall, the operation initializes this setting
#' to `TRUE`.
#' @param Description A description of the firewall.
#' @param Tags The key:value pairs to associate with the resource.
#' @param EncryptionConfiguration A complex type that contains settings for encryption of your firewall
#' resources.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_create_firewall
networkfirewall_create_firewall <- function(FirewallName, FirewallPolicyArn, VpcId, SubnetMappings, DeleteProtection = NULL, SubnetChangeProtection = NULL, FirewallPolicyChangeProtection = NULL, Description = NULL, Tags = NULL, EncryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFirewall",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$create_firewall_input(FirewallName = FirewallName, FirewallPolicyArn = FirewallPolicyArn, VpcId = VpcId, SubnetMappings = SubnetMappings, DeleteProtection = DeleteProtection, SubnetChangeProtection = SubnetChangeProtection, FirewallPolicyChangeProtection = FirewallPolicyChangeProtection, Description = Description, Tags = Tags, EncryptionConfiguration = EncryptionConfiguration)
  output <- .networkfirewall$create_firewall_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$create_firewall <- networkfirewall_create_firewall

#' Creates the firewall policy for the firewall according to the
#' specifications
#'
#' @description
#' Creates the firewall policy for the firewall according to the specifications.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_create_firewall_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_create_firewall_policy/) for full documentation.
#'
#' @param FirewallPolicyName &#91;required&#93; The descriptive name of the firewall policy. You can't change the name
#' of a firewall policy after you create it.
#' @param FirewallPolicy &#91;required&#93; The rule groups and policy actions to use in the firewall policy.
#' @param Description A description of the firewall policy.
#' @param Tags The key:value pairs to associate with the resource.
#' @param DryRun Indicates whether you want Network Firewall to just check the validity
#' of the request, rather than run the request.
#' 
#' If set to `TRUE`, Network Firewall checks whether the request can run
#' successfully, but doesn't actually make the requested changes. The call
#' returns the value that the request would return if you ran it with dry
#' run set to `FALSE`, but doesn't make additions or changes to your
#' resources. This option allows you to make sure that you have the
#' required permissions to run the request and that your request parameters
#' are valid.
#' 
#' If set to `FALSE`, Network Firewall makes the requested changes to your
#' resources.
#' @param EncryptionConfiguration A complex type that contains settings for encryption of your firewall
#' policy resources.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_create_firewall_policy
networkfirewall_create_firewall_policy <- function(FirewallPolicyName, FirewallPolicy, Description = NULL, Tags = NULL, DryRun = NULL, EncryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFirewallPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$create_firewall_policy_input(FirewallPolicyName = FirewallPolicyName, FirewallPolicy = FirewallPolicy, Description = Description, Tags = Tags, DryRun = DryRun, EncryptionConfiguration = EncryptionConfiguration)
  output <- .networkfirewall$create_firewall_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$create_firewall_policy <- networkfirewall_create_firewall_policy

#' Creates the specified stateless or stateful rule group, which includes
#' the rules for network traffic inspection, a capacity setting, and tags
#'
#' @description
#' Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_create_rule_group/](https://www.paws-r-sdk.com/docs/networkfirewall_create_rule_group/) for full documentation.
#'
#' @param RuleGroupName &#91;required&#93; The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' @param RuleGroup An object that defines the rule group rules.
#' 
#' You must provide either this rule group setting or a `Rules` setting,
#' but not both.
#' @param Rules A string containing stateful rule group rules specifications in Suricata
#' flat format, with one rule per line. Use this to import your existing
#' Suricata compatible rule groups.
#' 
#' You must provide either this rules setting or a populated `RuleGroup`
#' setting, but not both.
#' 
#' You can provide your rule group specification in Suricata flat format
#' through this setting when you create or update your rule group. The call
#' response returns a RuleGroup object that Network Firewall has populated
#' from your string.
#' @param Type &#91;required&#93; Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#' @param Description A description of the rule group.
#' @param Capacity &#91;required&#93; The maximum operating resources that this rule group can use. Rule group
#' capacity is fixed at creation. When you update a rule group, you are
#' limited to this capacity. When you reference a rule group from a
#' firewall policy, Network Firewall reserves this capacity for the rule
#' group.
#' 
#' You can retrieve the capacity that would be required for a rule group
#' before you create the rule group by calling
#' [`create_rule_group`][networkfirewall_create_rule_group] with `DryRun`
#' set to `TRUE`.
#' 
#' You can't change or exceed this capacity when you update the rule group,
#' so leave room for your rule group to grow.
#' 
#' **Capacity for a stateless rule group**
#' 
#' For a stateless rule group, the capacity required is the sum of the
#' capacity requirements of the individual rules that you expect to have in
#' the rule group.
#' 
#' To calculate the capacity requirement of a single rule, multiply the
#' capacity requirement values of each of the rule's match settings:
#' 
#' -   A match setting with no criteria specified has a value of 1.
#' 
#' -   A match setting with `Any` specified has a value of 1.
#' 
#' -   All other match settings have a value equal to the number of
#'     elements provided in the setting. For example, a protocol setting
#'     \["UDP"\] and a source setting \["10.0.0.0/24"\] each have a value
#'     of 1. A protocol setting \["UDP","TCP"\] has a value of 2. A source
#'     setting \["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"\] has a value of
#'     3.
#' 
#' A rule with no criteria specified in any of its match settings has a
#' capacity requirement of 1. A rule with protocol setting \["UDP","TCP"\],
#' source setting \["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"\], and a
#' single specification or no specification for each of the other match
#' settings has a capacity requirement of 6.
#' 
#' **Capacity for a stateful rule group**
#' 
#' For a stateful rule group, the minimum capacity required is the number
#' of individual rules that you expect to have in the rule group.
#' @param Tags The key:value pairs to associate with the resource.
#' @param DryRun Indicates whether you want Network Firewall to just check the validity
#' of the request, rather than run the request.
#' 
#' If set to `TRUE`, Network Firewall checks whether the request can run
#' successfully, but doesn't actually make the requested changes. The call
#' returns the value that the request would return if you ran it with dry
#' run set to `FALSE`, but doesn't make additions or changes to your
#' resources. This option allows you to make sure that you have the
#' required permissions to run the request and that your request parameters
#' are valid.
#' 
#' If set to `FALSE`, Network Firewall makes the requested changes to your
#' resources.
#' @param EncryptionConfiguration A complex type that contains settings for encryption of your rule group
#' resources.
#' @param SourceMetadata A complex type that contains metadata about the rule group that your own
#' rule group is copied from. You can use the metadata to keep track of
#' updates made to the originating rule group.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_create_rule_group
networkfirewall_create_rule_group <- function(RuleGroupName, RuleGroup = NULL, Rules = NULL, Type, Description = NULL, Capacity, Tags = NULL, DryRun = NULL, EncryptionConfiguration = NULL, SourceMetadata = NULL) {
  op <- new_operation(
    name = "CreateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$create_rule_group_input(RuleGroupName = RuleGroupName, RuleGroup = RuleGroup, Rules = Rules, Type = Type, Description = Description, Capacity = Capacity, Tags = Tags, DryRun = DryRun, EncryptionConfiguration = EncryptionConfiguration, SourceMetadata = SourceMetadata)
  output <- .networkfirewall$create_rule_group_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$create_rule_group <- networkfirewall_create_rule_group

#' Creates an Network Firewall TLS inspection configuration
#'
#' @description
#' Creates an Network Firewall TLS inspection configuration. A TLS inspection configuration contains the Certificate Manager certificate references that Network Firewall uses to decrypt and re-encrypt inbound traffic.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_create_tls_inspection_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_create_tls_inspection_configuration/) for full documentation.
#'
#' @param TLSInspectionConfigurationName &#91;required&#93; The descriptive name of the TLS inspection configuration. You can't
#' change the name of a TLS inspection configuration after you create it.
#' @param TLSInspectionConfiguration &#91;required&#93; The object that defines a TLS inspection configuration. This, along with
#' TLSInspectionConfigurationResponse, define the TLS inspection
#' configuration. You can retrieve all objects for a TLS inspection
#' configuration by calling
#' [`describe_tls_inspection_configuration`][networkfirewall_describe_tls_inspection_configuration].
#' 
#' Network Firewall uses a TLS inspection configuration to decrypt traffic.
#' Network Firewall re-encrypts the traffic before sending it to its
#' destination.
#' 
#' To use a TLS inspection configuration, you add it to a Network Firewall
#' firewall policy, then you apply the firewall policy to a firewall.
#' Network Firewall acts as a proxy service to decrypt and inspect inbound
#' traffic. You can reference a TLS inspection configuration from more than
#' one firewall policy, and you can use a firewall policy in more than one
#' firewall. For more information about using TLS inspection
#' configurations, see [Decrypting SSL/TLS traffic with TLS inspection
#' configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/)
#' in the *Network Firewall Developer Guide*.
#' @param Description A description of the TLS inspection configuration.
#' @param Tags The key:value pairs to associate with the resource.
#' @param EncryptionConfiguration 
#'
#' @keywords internal
#'
#' @rdname networkfirewall_create_tls_inspection_configuration
networkfirewall_create_tls_inspection_configuration <- function(TLSInspectionConfigurationName, TLSInspectionConfiguration, Description = NULL, Tags = NULL, EncryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateTLSInspectionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$create_tls_inspection_configuration_input(TLSInspectionConfigurationName = TLSInspectionConfigurationName, TLSInspectionConfiguration = TLSInspectionConfiguration, Description = Description, Tags = Tags, EncryptionConfiguration = EncryptionConfiguration)
  output <- .networkfirewall$create_tls_inspection_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$create_tls_inspection_configuration <- networkfirewall_create_tls_inspection_configuration

#' Deletes the specified Firewall and its FirewallStatus
#'
#' @description
#' Deletes the specified Firewall and its FirewallStatus. This operation requires the firewall's `DeleteProtection` flag to be `FALSE`. You can't revert this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_delete_firewall/](https://www.paws-r-sdk.com/docs/networkfirewall_delete_firewall/) for full documentation.
#'
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_delete_firewall
networkfirewall_delete_firewall <- function(FirewallName = NULL, FirewallArn = NULL) {
  op <- new_operation(
    name = "DeleteFirewall",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$delete_firewall_input(FirewallName = FirewallName, FirewallArn = FirewallArn)
  output <- .networkfirewall$delete_firewall_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$delete_firewall <- networkfirewall_delete_firewall

#' Deletes the specified FirewallPolicy
#'
#' @description
#' Deletes the specified FirewallPolicy.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_delete_firewall_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_delete_firewall_policy/) for full documentation.
#'
#' @param FirewallPolicyName The descriptive name of the firewall policy. You can't change the name
#' of a firewall policy after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicyArn The Amazon Resource Name (ARN) of the firewall policy.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_delete_firewall_policy
networkfirewall_delete_firewall_policy <- function(FirewallPolicyName = NULL, FirewallPolicyArn = NULL) {
  op <- new_operation(
    name = "DeleteFirewallPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$delete_firewall_policy_input(FirewallPolicyName = FirewallPolicyName, FirewallPolicyArn = FirewallPolicyArn)
  output <- .networkfirewall$delete_firewall_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$delete_firewall_policy <- networkfirewall_delete_firewall_policy

#' Deletes a resource policy that you created in a PutResourcePolicy
#' request
#'
#' @description
#' Deletes a resource policy that you created in a [`put_resource_policy`][networkfirewall_put_resource_policy] request.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_delete_resource_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_delete_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule group or firewall policy
#' whose resource policy you want to delete.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_delete_resource_policy
networkfirewall_delete_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$delete_resource_policy_input(ResourceArn = ResourceArn)
  output <- .networkfirewall$delete_resource_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$delete_resource_policy <- networkfirewall_delete_resource_policy

#' Deletes the specified RuleGroup
#'
#' @description
#' Deletes the specified RuleGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_delete_rule_group/](https://www.paws-r-sdk.com/docs/networkfirewall_delete_rule_group/) for full documentation.
#'
#' @param RuleGroupName The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param RuleGroupArn The Amazon Resource Name (ARN) of the rule group.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param Type Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#' 
#' This setting is required for requests that do not include the
#' `RuleGroupARN`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_delete_rule_group
networkfirewall_delete_rule_group <- function(RuleGroupName = NULL, RuleGroupArn = NULL, Type = NULL) {
  op <- new_operation(
    name = "DeleteRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$delete_rule_group_input(RuleGroupName = RuleGroupName, RuleGroupArn = RuleGroupArn, Type = Type)
  output <- .networkfirewall$delete_rule_group_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$delete_rule_group <- networkfirewall_delete_rule_group

#' Deletes the specified TLSInspectionConfiguration
#'
#' @description
#' Deletes the specified TLSInspectionConfiguration.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_delete_tls_inspection_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_delete_tls_inspection_configuration/) for full documentation.
#'
#' @param TLSInspectionConfigurationArn The Amazon Resource Name (ARN) of the TLS inspection configuration.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param TLSInspectionConfigurationName The descriptive name of the TLS inspection configuration. You can't
#' change the name of a TLS inspection configuration after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_delete_tls_inspection_configuration
networkfirewall_delete_tls_inspection_configuration <- function(TLSInspectionConfigurationArn = NULL, TLSInspectionConfigurationName = NULL) {
  op <- new_operation(
    name = "DeleteTLSInspectionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$delete_tls_inspection_configuration_input(TLSInspectionConfigurationArn = TLSInspectionConfigurationArn, TLSInspectionConfigurationName = TLSInspectionConfigurationName)
  output <- .networkfirewall$delete_tls_inspection_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$delete_tls_inspection_configuration <- networkfirewall_delete_tls_inspection_configuration

#' Returns the data objects for the specified firewall
#'
#' @description
#' Returns the data objects for the specified firewall.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_firewall/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_firewall/) for full documentation.
#'
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_firewall
networkfirewall_describe_firewall <- function(FirewallName = NULL, FirewallArn = NULL) {
  op <- new_operation(
    name = "DescribeFirewall",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_firewall_input(FirewallName = FirewallName, FirewallArn = FirewallArn)
  output <- .networkfirewall$describe_firewall_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_firewall <- networkfirewall_describe_firewall

#' Returns the data objects for the specified firewall policy
#'
#' @description
#' Returns the data objects for the specified firewall policy.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_firewall_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_firewall_policy/) for full documentation.
#'
#' @param FirewallPolicyName The descriptive name of the firewall policy. You can't change the name
#' of a firewall policy after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicyArn The Amazon Resource Name (ARN) of the firewall policy.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_firewall_policy
networkfirewall_describe_firewall_policy <- function(FirewallPolicyName = NULL, FirewallPolicyArn = NULL) {
  op <- new_operation(
    name = "DescribeFirewallPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_firewall_policy_input(FirewallPolicyName = FirewallPolicyName, FirewallPolicyArn = FirewallPolicyArn)
  output <- .networkfirewall$describe_firewall_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_firewall_policy <- networkfirewall_describe_firewall_policy

#' Returns the logging configuration for the specified firewall
#'
#' @description
#' Returns the logging configuration for the specified firewall.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_logging_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_logging_configuration/) for full documentation.
#'
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_logging_configuration
networkfirewall_describe_logging_configuration <- function(FirewallArn = NULL, FirewallName = NULL) {
  op <- new_operation(
    name = "DescribeLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_logging_configuration_input(FirewallArn = FirewallArn, FirewallName = FirewallName)
  output <- .networkfirewall$describe_logging_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_logging_configuration <- networkfirewall_describe_logging_configuration

#' Retrieves a resource policy that you created in a PutResourcePolicy
#' request
#'
#' @description
#' Retrieves a resource policy that you created in a [`put_resource_policy`][networkfirewall_put_resource_policy] request.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_resource_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule group or firewall policy
#' whose resource policy you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_resource_policy
networkfirewall_describe_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DescribeResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_resource_policy_input(ResourceArn = ResourceArn)
  output <- .networkfirewall$describe_resource_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_resource_policy <- networkfirewall_describe_resource_policy

#' Returns the data objects for the specified rule group
#'
#' @description
#' Returns the data objects for the specified rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_rule_group/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_rule_group/) for full documentation.
#'
#' @param RuleGroupName The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param RuleGroupArn The Amazon Resource Name (ARN) of the rule group.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param Type Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#' 
#' This setting is required for requests that do not include the
#' `RuleGroupARN`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_rule_group
networkfirewall_describe_rule_group <- function(RuleGroupName = NULL, RuleGroupArn = NULL, Type = NULL) {
  op <- new_operation(
    name = "DescribeRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_rule_group_input(RuleGroupName = RuleGroupName, RuleGroupArn = RuleGroupArn, Type = Type)
  output <- .networkfirewall$describe_rule_group_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_rule_group <- networkfirewall_describe_rule_group

#' High-level information about a rule group, returned by operations like
#' create and describe
#'
#' @description
#' High-level information about a rule group, returned by operations like create and describe. You can use the information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule group by calling [`describe_rule_group`][networkfirewall_describe_rule_group].
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_rule_group_metadata/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_rule_group_metadata/) for full documentation.
#'
#' @param RuleGroupName The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param RuleGroupArn The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param Type Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#' 
#' This setting is required for requests that do not include the
#' `RuleGroupARN`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_rule_group_metadata
networkfirewall_describe_rule_group_metadata <- function(RuleGroupName = NULL, RuleGroupArn = NULL, Type = NULL) {
  op <- new_operation(
    name = "DescribeRuleGroupMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_rule_group_metadata_input(RuleGroupName = RuleGroupName, RuleGroupArn = RuleGroupArn, Type = Type)
  output <- .networkfirewall$describe_rule_group_metadata_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_rule_group_metadata <- networkfirewall_describe_rule_group_metadata

#' Returns the data objects for the specified TLS inspection configuration
#'
#' @description
#' Returns the data objects for the specified TLS inspection configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_describe_tls_inspection_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_describe_tls_inspection_configuration/) for full documentation.
#'
#' @param TLSInspectionConfigurationArn The Amazon Resource Name (ARN) of the TLS inspection configuration.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param TLSInspectionConfigurationName The descriptive name of the TLS inspection configuration. You can't
#' change the name of a TLS inspection configuration after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_describe_tls_inspection_configuration
networkfirewall_describe_tls_inspection_configuration <- function(TLSInspectionConfigurationArn = NULL, TLSInspectionConfigurationName = NULL) {
  op <- new_operation(
    name = "DescribeTLSInspectionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$describe_tls_inspection_configuration_input(TLSInspectionConfigurationArn = TLSInspectionConfigurationArn, TLSInspectionConfigurationName = TLSInspectionConfigurationName)
  output <- .networkfirewall$describe_tls_inspection_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$describe_tls_inspection_configuration <- networkfirewall_describe_tls_inspection_configuration

#' Removes the specified subnet associations from the firewall
#'
#' @description
#' Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_disassociate_subnets/](https://www.paws-r-sdk.com/docs/networkfirewall_disassociate_subnets/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param SubnetIds &#91;required&#93; The unique identifiers for the subnets that you want to disassociate.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_disassociate_subnets
networkfirewall_disassociate_subnets <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, SubnetIds) {
  op <- new_operation(
    name = "DisassociateSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$disassociate_subnets_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, SubnetIds = SubnetIds)
  output <- .networkfirewall$disassociate_subnets_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$disassociate_subnets <- networkfirewall_disassociate_subnets

#' Retrieves the metadata for the firewall policies that you have defined
#'
#' @description
#' Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_list_firewall_policies/](https://www.paws-r-sdk.com/docs/networkfirewall_list_firewall_policies/) for full documentation.
#'
#' @param NextToken When you request a list of objects with a `MaxResults` setting, if the
#' number of objects that are still available for retrieval exceeds the
#' maximum you requested, Network Firewall returns a `NextToken` value in
#' the response. To retrieve the next batch of objects, use the token
#' returned from the prior request in your next request.
#' @param MaxResults The maximum number of objects that you want Network Firewall to return
#' for this request. If more objects are available, in the response,
#' Network Firewall provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_list_firewall_policies
networkfirewall_list_firewall_policies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFirewallPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$list_firewall_policies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .networkfirewall$list_firewall_policies_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$list_firewall_policies <- networkfirewall_list_firewall_policies

#' Retrieves the metadata for the firewalls that you have defined
#'
#' @description
#' Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request, this returns only the firewalls for those VPCs.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_list_firewalls/](https://www.paws-r-sdk.com/docs/networkfirewall_list_firewalls/) for full documentation.
#'
#' @param NextToken When you request a list of objects with a `MaxResults` setting, if the
#' number of objects that are still available for retrieval exceeds the
#' maximum you requested, Network Firewall returns a `NextToken` value in
#' the response. To retrieve the next batch of objects, use the token
#' returned from the prior request in your next request.
#' @param VpcIds The unique identifiers of the VPCs that you want Network Firewall to
#' retrieve the firewalls for. Leave this blank to retrieve all firewalls
#' that you have defined.
#' @param MaxResults The maximum number of objects that you want Network Firewall to return
#' for this request. If more objects are available, in the response,
#' Network Firewall provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_list_firewalls
networkfirewall_list_firewalls <- function(NextToken = NULL, VpcIds = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFirewalls",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$list_firewalls_input(NextToken = NextToken, VpcIds = VpcIds, MaxResults = MaxResults)
  output <- .networkfirewall$list_firewalls_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$list_firewalls <- networkfirewall_list_firewalls

#' Retrieves the metadata for the rule groups that you have defined
#'
#' @description
#' Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_list_rule_groups/](https://www.paws-r-sdk.com/docs/networkfirewall_list_rule_groups/) for full documentation.
#'
#' @param NextToken When you request a list of objects with a `MaxResults` setting, if the
#' number of objects that are still available for retrieval exceeds the
#' maximum you requested, Network Firewall returns a `NextToken` value in
#' the response. To retrieve the next batch of objects, use the token
#' returned from the prior request in your next request.
#' @param MaxResults The maximum number of objects that you want Network Firewall to return
#' for this request. If more objects are available, in the response,
#' Network Firewall provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#' @param Scope The scope of the request. The default setting of `ACCOUNT` or a setting
#' of `NULL` returns all of the rule groups in your account. A setting of
#' `MANAGED` returns all available managed rule groups.
#' @param ManagedType Indicates the general category of the Amazon Web Services managed rule
#' group.
#' @param Type Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_list_rule_groups
networkfirewall_list_rule_groups <- function(NextToken = NULL, MaxResults = NULL, Scope = NULL, ManagedType = NULL, Type = NULL) {
  op <- new_operation(
    name = "ListRuleGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$list_rule_groups_input(NextToken = NextToken, MaxResults = MaxResults, Scope = Scope, ManagedType = ManagedType, Type = Type)
  output <- .networkfirewall$list_rule_groups_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$list_rule_groups <- networkfirewall_list_rule_groups

#' Retrieves the metadata for the TLS inspection configurations that you
#' have defined
#'
#' @description
#' Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for max results and the number of TLS inspection configurations, a single call might not return the full list.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_list_tls_inspection_configurations/](https://www.paws-r-sdk.com/docs/networkfirewall_list_tls_inspection_configurations/) for full documentation.
#'
#' @param NextToken When you request a list of objects with a `MaxResults` setting, if the
#' number of objects that are still available for retrieval exceeds the
#' maximum you requested, Network Firewall returns a `NextToken` value in
#' the response. To retrieve the next batch of objects, use the token
#' returned from the prior request in your next request.
#' @param MaxResults The maximum number of objects that you want Network Firewall to return
#' for this request. If more objects are available, in the response,
#' Network Firewall provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_list_tls_inspection_configurations
networkfirewall_list_tls_inspection_configurations <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTLSInspectionConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$list_tls_inspection_configurations_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .networkfirewall$list_tls_inspection_configurations_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$list_tls_inspection_configurations <- networkfirewall_list_tls_inspection_configurations

#' Retrieves the tags associated with the specified resource
#'
#' @description
#' Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/networkfirewall_list_tags_for_resource/) for full documentation.
#'
#' @param NextToken When you request a list of objects with a `MaxResults` setting, if the
#' number of objects that are still available for retrieval exceeds the
#' maximum you requested, Network Firewall returns a `NextToken` value in
#' the response. To retrieve the next batch of objects, use the token
#' returned from the prior request in your next request.
#' @param MaxResults The maximum number of objects that you want Network Firewall to return
#' for this request. If more objects are available, in the response,
#' Network Firewall provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_list_tags_for_resource
networkfirewall_list_tags_for_resource <- function(NextToken = NULL, MaxResults = NULL, ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$list_tags_for_resource_input(NextToken = NextToken, MaxResults = MaxResults, ResourceArn = ResourceArn)
  output <- .networkfirewall$list_tags_for_resource_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$list_tags_for_resource <- networkfirewall_list_tags_for_resource

#' Creates or updates an IAM policy for your rule group or firewall policy
#'
#' @description
#' Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_put_resource_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_put_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the account that you want to share
#' rule groups and firewall policies with.
#' @param Policy &#91;required&#93; The IAM policy statement that lists the accounts that you want to share
#' your rule group or firewall policy with and the operations that you want
#' the accounts to be able to perform.
#' 
#' For a rule group resource, you can specify the following operations in
#' the Actions section of the statement:
#' 
#' -   network-firewall:CreateFirewallPolicy
#' 
#' -   network-firewall:UpdateFirewallPolicy
#' 
#' -   network-firewall:ListRuleGroups
#' 
#' For a firewall policy resource, you can specify the following operations
#' in the Actions section of the statement:
#' 
#' -   network-firewall:AssociateFirewallPolicy
#' 
#' -   network-firewall:ListFirewallPolicies
#' 
#' In the Resource section of the statement, you specify the ARNs for the
#' rule groups and firewall policies that you want to share with the
#' account that you specified in `Arn`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_put_resource_policy
networkfirewall_put_resource_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$put_resource_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .networkfirewall$put_resource_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$put_resource_policy <- networkfirewall_put_resource_policy

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_tag_resource/](https://www.paws-r-sdk.com/docs/networkfirewall_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname networkfirewall_tag_resource
networkfirewall_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .networkfirewall$tag_resource_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$tag_resource <- networkfirewall_tag_resource

#' Removes the tags with the specified keys from the specified resource
#'
#' @description
#' Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_untag_resource/](https://www.paws-r-sdk.com/docs/networkfirewall_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname networkfirewall_untag_resource
networkfirewall_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .networkfirewall$untag_resource_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$untag_resource <- networkfirewall_untag_resource

#' Modifies the flag, DeleteProtection, which indicates whether it is
#' possible to delete the firewall
#'
#' @description
#' Modifies the flag, `DeleteProtection`, which indicates whether it is possible to delete the firewall. If the flag is set to `TRUE`, the firewall is protected against deletion. This setting helps protect against accidentally deleting a firewall that's in use.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_delete_protection/](https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_delete_protection/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param DeleteProtection &#91;required&#93; A flag indicating whether it is possible to delete the firewall. A
#' setting of `TRUE` indicates that the firewall is protected against
#' deletion. Use this setting to protect against accidentally deleting a
#' firewall that is in use. When you create a firewall, the operation
#' initializes this flag to `TRUE`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_firewall_delete_protection
networkfirewall_update_firewall_delete_protection <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, DeleteProtection) {
  op <- new_operation(
    name = "UpdateFirewallDeleteProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_firewall_delete_protection_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, DeleteProtection = DeleteProtection)
  output <- .networkfirewall$update_firewall_delete_protection_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_firewall_delete_protection <- networkfirewall_update_firewall_delete_protection

#' Modifies the description for the specified firewall
#'
#' @description
#' Modifies the description for the specified firewall. Use the description to help you identify the firewall when you're working with it.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_description/](https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_description/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param Description The new description for the firewall. If you omit this setting, Network
#' Firewall removes the description for the firewall.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_firewall_description
networkfirewall_update_firewall_description <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateFirewallDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_firewall_description_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, Description = Description)
  output <- .networkfirewall$update_firewall_description_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_firewall_description <- networkfirewall_update_firewall_description

#' A complex type that contains settings for encryption of your firewall
#' resources
#'
#' @description
#' A complex type that contains settings for encryption of your firewall resources.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_encryption_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_encryption_configuration/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' @param EncryptionConfiguration 
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_firewall_encryption_configuration
networkfirewall_update_firewall_encryption_configuration <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, EncryptionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateFirewallEncryptionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_firewall_encryption_configuration_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, EncryptionConfiguration = EncryptionConfiguration)
  output <- .networkfirewall$update_firewall_encryption_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_firewall_encryption_configuration <- networkfirewall_update_firewall_encryption_configuration

#' Updates the properties of the specified firewall policy
#'
#' @description
#' Updates the properties of the specified firewall policy.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_policy/](https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_policy/) for full documentation.
#'
#' @param UpdateToken &#91;required&#93; A token used for optimistic locking. Network Firewall returns a token to
#' your requests that access the firewall policy. The token marks the state
#' of the policy resource at the time of the request.
#' 
#' To make changes to the policy, you provide the token in your request.
#' Network Firewall uses the token to ensure that the policy hasn't changed
#' since you last retrieved it. If it has changed, the operation fails with
#' an `InvalidTokenException`. If this happens, retrieve the firewall
#' policy again to get a current copy of it with current token. Reapply
#' your changes as needed, then try the operation again using the new
#' token.
#' @param FirewallPolicyArn The Amazon Resource Name (ARN) of the firewall policy.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicyName The descriptive name of the firewall policy. You can't change the name
#' of a firewall policy after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicy &#91;required&#93; The updated firewall policy to use for the firewall.
#' @param Description A description of the firewall policy.
#' @param DryRun Indicates whether you want Network Firewall to just check the validity
#' of the request, rather than run the request.
#' 
#' If set to `TRUE`, Network Firewall checks whether the request can run
#' successfully, but doesn't actually make the requested changes. The call
#' returns the value that the request would return if you ran it with dry
#' run set to `FALSE`, but doesn't make additions or changes to your
#' resources. This option allows you to make sure that you have the
#' required permissions to run the request and that your request parameters
#' are valid.
#' 
#' If set to `FALSE`, Network Firewall makes the requested changes to your
#' resources.
#' @param EncryptionConfiguration A complex type that contains settings for encryption of your firewall
#' policy resources.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_firewall_policy
networkfirewall_update_firewall_policy <- function(UpdateToken, FirewallPolicyArn = NULL, FirewallPolicyName = NULL, FirewallPolicy, Description = NULL, DryRun = NULL, EncryptionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateFirewallPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_firewall_policy_input(UpdateToken = UpdateToken, FirewallPolicyArn = FirewallPolicyArn, FirewallPolicyName = FirewallPolicyName, FirewallPolicy = FirewallPolicy, Description = Description, DryRun = DryRun, EncryptionConfiguration = EncryptionConfiguration)
  output <- .networkfirewall$update_firewall_policy_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_firewall_policy <- networkfirewall_update_firewall_policy

#' Modifies the flag, ChangeProtection, which indicates whether it is
#' possible to change the firewall
#'
#' @description
#' Modifies the flag, `ChangeProtection`, which indicates whether it is possible to change the firewall. If the flag is set to `TRUE`, the firewall is protected from changes. This setting helps protect against accidentally changing a firewall that's in use.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_policy_change_protection/](https://www.paws-r-sdk.com/docs/networkfirewall_update_firewall_policy_change_protection/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallPolicyChangeProtection &#91;required&#93; A setting indicating whether the firewall is protected against a change
#' to the firewall policy association. Use this setting to protect against
#' accidentally modifying the firewall policy for a firewall that is in
#' use. When you create a firewall, the operation initializes this setting
#' to `TRUE`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_firewall_policy_change_protection
networkfirewall_update_firewall_policy_change_protection <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, FirewallPolicyChangeProtection) {
  op <- new_operation(
    name = "UpdateFirewallPolicyChangeProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_firewall_policy_change_protection_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, FirewallPolicyChangeProtection = FirewallPolicyChangeProtection)
  output <- .networkfirewall$update_firewall_policy_change_protection_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_firewall_policy_change_protection <- networkfirewall_update_firewall_policy_change_protection

#' Sets the logging configuration for the specified firewall
#'
#' @description
#' Sets the logging configuration for the specified firewall.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_logging_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_update_logging_configuration/) for full documentation.
#'
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param LoggingConfiguration Defines how Network Firewall performs logging for a firewall. If you
#' omit this setting, Network Firewall disables logging for the firewall.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_logging_configuration
networkfirewall_update_logging_configuration <- function(FirewallArn = NULL, FirewallName = NULL, LoggingConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_logging_configuration_input(FirewallArn = FirewallArn, FirewallName = FirewallName, LoggingConfiguration = LoggingConfiguration)
  output <- .networkfirewall$update_logging_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_logging_configuration <- networkfirewall_update_logging_configuration

#' Updates the rule settings for the specified rule group
#'
#' @description
#' Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_rule_group/](https://www.paws-r-sdk.com/docs/networkfirewall_update_rule_group/) for full documentation.
#'
#' @param UpdateToken &#91;required&#93; A token used for optimistic locking. Network Firewall returns a token to
#' your requests that access the rule group. The token marks the state of
#' the rule group resource at the time of the request.
#' 
#' To make changes to the rule group, you provide the token in your
#' request. Network Firewall uses the token to ensure that the rule group
#' hasn't changed since you last retrieved it. If it has changed, the
#' operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the rule group again to get a current copy of it with a current
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param RuleGroupArn The Amazon Resource Name (ARN) of the rule group.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param RuleGroupName The descriptive name of the rule group. You can't change the name of a
#' rule group after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param RuleGroup An object that defines the rule group rules.
#' 
#' You must provide either this rule group setting or a `Rules` setting,
#' but not both.
#' @param Rules A string containing stateful rule group rules specifications in Suricata
#' flat format, with one rule per line. Use this to import your existing
#' Suricata compatible rule groups.
#' 
#' You must provide either this rules setting or a populated `RuleGroup`
#' setting, but not both.
#' 
#' You can provide your rule group specification in Suricata flat format
#' through this setting when you create or update your rule group. The call
#' response returns a RuleGroup object that Network Firewall has populated
#' from your string.
#' @param Type Indicates whether the rule group is stateless or stateful. If the rule
#' group is stateless, it contains stateless rules. If it is stateful, it
#' contains stateful rules.
#' 
#' This setting is required for requests that do not include the
#' `RuleGroupARN`.
#' @param Description A description of the rule group.
#' @param DryRun Indicates whether you want Network Firewall to just check the validity
#' of the request, rather than run the request.
#' 
#' If set to `TRUE`, Network Firewall checks whether the request can run
#' successfully, but doesn't actually make the requested changes. The call
#' returns the value that the request would return if you ran it with dry
#' run set to `FALSE`, but doesn't make additions or changes to your
#' resources. This option allows you to make sure that you have the
#' required permissions to run the request and that your request parameters
#' are valid.
#' 
#' If set to `FALSE`, Network Firewall makes the requested changes to your
#' resources.
#' @param EncryptionConfiguration A complex type that contains settings for encryption of your rule group
#' resources.
#' @param SourceMetadata A complex type that contains metadata about the rule group that your own
#' rule group is copied from. You can use the metadata to keep track of
#' updates made to the originating rule group.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_rule_group
networkfirewall_update_rule_group <- function(UpdateToken, RuleGroupArn = NULL, RuleGroupName = NULL, RuleGroup = NULL, Rules = NULL, Type = NULL, Description = NULL, DryRun = NULL, EncryptionConfiguration = NULL, SourceMetadata = NULL) {
  op <- new_operation(
    name = "UpdateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_rule_group_input(UpdateToken = UpdateToken, RuleGroupArn = RuleGroupArn, RuleGroupName = RuleGroupName, RuleGroup = RuleGroup, Rules = Rules, Type = Type, Description = Description, DryRun = DryRun, EncryptionConfiguration = EncryptionConfiguration, SourceMetadata = SourceMetadata)
  output <- .networkfirewall$update_rule_group_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_rule_group <- networkfirewall_update_rule_group

#' Update subnet change protection
#'
#' @description
#' Update subnet change protection
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_subnet_change_protection/](https://www.paws-r-sdk.com/docs/networkfirewall_update_subnet_change_protection/) for full documentation.
#'
#' @param UpdateToken An optional token that you can use for optimistic locking. Network
#' Firewall returns a token to your requests that access the firewall. The
#' token marks the state of the firewall resource at the time of the
#' request.
#' 
#' To make an unconditional change to the firewall, omit the token in your
#' update request. Without the token, Network Firewall performs your
#' updates regardless of whether the firewall has changed since you last
#' retrieved it.
#' 
#' To make a conditional change to the firewall, provide the token in your
#' update request. Network Firewall uses the token to ensure that the
#' firewall hasn't changed since you last retrieved it. If it has changed,
#' the operation fails with an `InvalidTokenException`. If this happens,
#' retrieve the firewall again to get a current copy of it with a new
#' token. Reapply your changes as needed, then try the operation again
#' using the new token.
#' @param FirewallArn The Amazon Resource Name (ARN) of the firewall.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param FirewallName The descriptive name of the firewall. You can't change the name of a
#' firewall after you create it.
#' 
#' You must specify the ARN or the name, and you can specify both.
#' @param SubnetChangeProtection &#91;required&#93; A setting indicating whether the firewall is protected against changes
#' to the subnet associations. Use this setting to protect against
#' accidentally modifying the subnet associations for a firewall that is in
#' use. When you create a firewall, the operation initializes this setting
#' to `TRUE`.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_subnet_change_protection
networkfirewall_update_subnet_change_protection <- function(UpdateToken = NULL, FirewallArn = NULL, FirewallName = NULL, SubnetChangeProtection) {
  op <- new_operation(
    name = "UpdateSubnetChangeProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_subnet_change_protection_input(UpdateToken = UpdateToken, FirewallArn = FirewallArn, FirewallName = FirewallName, SubnetChangeProtection = SubnetChangeProtection)
  output <- .networkfirewall$update_subnet_change_protection_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_subnet_change_protection <- networkfirewall_update_subnet_change_protection

#' Updates the TLS inspection configuration settings for the specified TLS
#' inspection configuration
#'
#' @description
#' Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS inspection configuration by reference in one or more firewall policies. When you modify a TLS inspection configuration, you modify all firewall policies that use the TLS inspection configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/networkfirewall_update_tls_inspection_configuration/](https://www.paws-r-sdk.com/docs/networkfirewall_update_tls_inspection_configuration/) for full documentation.
#'
#' @param TLSInspectionConfigurationArn The Amazon Resource Name (ARN) of the TLS inspection configuration.
#' @param TLSInspectionConfigurationName The descriptive name of the TLS inspection configuration. You can't
#' change the name of a TLS inspection configuration after you create it.
#' @param TLSInspectionConfiguration &#91;required&#93; The object that defines a TLS inspection configuration. This, along with
#' TLSInspectionConfigurationResponse, define the TLS inspection
#' configuration. You can retrieve all objects for a TLS inspection
#' configuration by calling
#' [`describe_tls_inspection_configuration`][networkfirewall_describe_tls_inspection_configuration].
#' 
#' Network Firewall uses a TLS inspection configuration to decrypt traffic.
#' Network Firewall re-encrypts the traffic before sending it to its
#' destination.
#' 
#' To use a TLS inspection configuration, you add it to a Network Firewall
#' firewall policy, then you apply the firewall policy to a firewall.
#' Network Firewall acts as a proxy service to decrypt and inspect inbound
#' traffic. You can reference a TLS inspection configuration from more than
#' one firewall policy, and you can use a firewall policy in more than one
#' firewall. For more information about using TLS inspection
#' configurations, see [Decrypting SSL/TLS traffic with TLS inspection
#' configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/)
#' in the *Network Firewall Developer Guide*.
#' @param Description A description of the TLS inspection configuration.
#' @param EncryptionConfiguration A complex type that contains the Amazon Web Services KMS encryption
#' configuration settings for your TLS inspection configuration.
#' @param UpdateToken &#91;required&#93; A token used for optimistic locking. Network Firewall returns a token to
#' your requests that access the TLS inspection configuration. The token
#' marks the state of the TLS inspection configuration resource at the time
#' of the request.
#' 
#' To make changes to the TLS inspection configuration, you provide the
#' token in your request. Network Firewall uses the token to ensure that
#' the TLS inspection configuration hasn't changed since you last retrieved
#' it. If it has changed, the operation fails with an
#' `InvalidTokenException`. If this happens, retrieve the TLS inspection
#' configuration again to get a current copy of it with a current token.
#' Reapply your changes as needed, then try the operation again using the
#' new token.
#'
#' @keywords internal
#'
#' @rdname networkfirewall_update_tls_inspection_configuration
networkfirewall_update_tls_inspection_configuration <- function(TLSInspectionConfigurationArn = NULL, TLSInspectionConfigurationName = NULL, TLSInspectionConfiguration, Description = NULL, EncryptionConfiguration = NULL, UpdateToken) {
  op <- new_operation(
    name = "UpdateTLSInspectionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .networkfirewall$update_tls_inspection_configuration_input(TLSInspectionConfigurationArn = TLSInspectionConfigurationArn, TLSInspectionConfigurationName = TLSInspectionConfigurationName, TLSInspectionConfiguration = TLSInspectionConfiguration, Description = Description, EncryptionConfiguration = EncryptionConfiguration, UpdateToken = UpdateToken)
  output <- .networkfirewall$update_tls_inspection_configuration_output()
  config <- get_config()
  svc <- .networkfirewall$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkfirewall$operations$update_tls_inspection_configuration <- networkfirewall_update_tls_inspection_configuration
