% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_create_listener}
\alias{globalaccelerator_create_listener}
\title{Create a listener to process inbound connections from clients to an
accelerator}
\usage{
globalaccelerator_create_listener(
  AcceleratorArn,
  PortRanges,
  Protocol,
  ClientAffinity = NULL,
  IdempotencyToken
)
}
\arguments{
\item{AcceleratorArn}{[required] The Amazon Resource Name (ARN) of your accelerator.}

\item{PortRanges}{[required] The list of port ranges to support for connections from clients to your
accelerator.}

\item{Protocol}{[required] The protocol for connections from clients to your accelerator.}

\item{ClientAffinity}{Client affinity lets you direct all requests from a user to the same
endpoint, if you have stateful applications, regardless of the port and
protocol of the client request. Client affinity gives you control over
whether to always route each client to the same specific endpoint.

Global Accelerator uses a consistent-flow hashing algorithm to choose
the optimal endpoint for a connection. If client affinity is \code{NONE},
Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
address, source port, destination IP address, destination port, and
protocol—to select the hash value, and then chooses the best endpoint.
However, with this setting, if someone uses different ports to connect
to Global Accelerator, their connections might not be always routed to
the same endpoint because the hash value changes.

If you want a given client to always be routed to the same endpoint, set
client affinity to \code{SOURCE_IP} instead. When you use the \code{SOURCE_IP}
setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
source (client) IP address and destination IP address—to select the hash
value.

The default value is \code{NONE}.}

\item{IdempotencyToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency—that is, the uniqueness—of the request.}
}
\description{
Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.

See \url{https://paws-r.github.io/docs/globalaccelerator/create_listener.html} for full documentation.
}
\keyword{internal}
