% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_virtual_service}
\alias{appmesh_update_virtual_service}
\title{Updates an existing virtual service in a specified service mesh}
\usage{
appmesh_update_virtual_service(
  clientToken = NULL,
  meshName,
  meshOwner = NULL,
  spec,
  virtualServiceName
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the virtual service resides in.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The new virtual service specification to apply. This overwrites the
existing data.}

\item{virtualServiceName}{[required] The name of the virtual service to update.}
}
\description{
Updates an existing virtual service in a specified service mesh.

See \url{https://paws-r.github.io/docs/appmesh/update_virtual_service.html} for full documentation.
}
\keyword{internal}
