% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_stage}
\alias{apigateway_create_stage}
\title{Creates a new Stage resource that references a pre-existing Deployment
for the API}
\usage{
apigateway_create_stage(
  restApiId,
  stageName,
  deploymentId,
  description = NULL,
  cacheClusterEnabled = NULL,
  cacheClusterSize = NULL,
  variables = NULL,
  documentationVersion = NULL,
  canarySettings = NULL,
  tracingEnabled = NULL,
  tags = NULL
)
}
\arguments{
\item{restApiId}{[required] The string identifier of the associated RestApi.}

\item{stageName}{[required] The name for the Stage resource. Stage names can only contain
alphanumeric characters, hyphens, and underscores. Maximum length is 128
characters.}

\item{deploymentId}{[required] The identifier of the Deployment resource for the Stage resource.}

\item{description}{The description of the Stage resource.}

\item{cacheClusterEnabled}{Whether cache clustering is enabled for the stage.}

\item{cacheClusterSize}{The stage's cache cluster size.}

\item{variables}{A map that defines the stage variables for the new Stage resource.
Variable names can have alphanumeric and underscore characters, and the
values must match \verb{[A-Za-z0-9-._~:/?#&=,]+}.}

\item{documentationVersion}{The version of the associated API documentation.}

\item{canarySettings}{The canary deployment settings of this stage.}

\item{tracingEnabled}{Specifies whether active tracing with X-ray is enabled for the Stage.}

\item{tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not
start with \verb{aws:}. The tag value can be up to 256 characters.}
}
\description{
Creates a new Stage resource that references a pre-existing Deployment for the API.

See \url{https://paws-r.github.io/docs/apigateway/create_stage.html} for full documentation.
}
\keyword{internal}
