% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_realtime_log_config}
\alias{cloudfront_list_distributions_by_realtime_log_config}
\title{Gets a list of distributions that have a cache behavior that’s
associated with the specified real-time log configuration}
\usage{
cloudfront_list_distributions_by_realtime_log_config(Marker, MaxItems,
  RealtimeLogConfigName, RealtimeLogConfigArn)
}
\arguments{
\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of distributions. The response includes distributions in the
list that occur after the marker. To get the next page of the list, set
this field’s value to the value of \code{NextMarker} from the current page’s
response.}

\item{MaxItems}{The maximum number of distributions that you want in the response.}

\item{RealtimeLogConfigName}{The name of the real-time log configuration whose associated
distributions you want to list.}

\item{RealtimeLogConfigArn}{The Amazon Resource Name (ARN) of the real-time log configuration whose
associated distributions you want to list.}
}
\value{
A list with the following syntax:\preformatted{list(
  DistributionList = list(
    Marker = "string",
    NextMarker = "string",
    MaxItems = 123,
    IsTruncated = TRUE|FALSE,
    Quantity = 123,
    Items = list(
      list(
        Id = "string",
        ARN = "string",
        Status = "string",
        LastModifiedTime = as.POSIXct(
          "2015-01-01"
        ),
        DomainName = "string",
        Aliases = list(
          Quantity = 123,
          Items = list(
            "string"
          )
        ),
        Origins = list(
          Quantity = 123,
          Items = list(
            list(
              Id = "string",
              DomainName = "string",
              OriginPath = "string",
              CustomHeaders = list(
                Quantity = 123,
                Items = list(
                  list(
                    HeaderName = "string",
                    HeaderValue = "string"
                  )
                )
              ),
              S3OriginConfig = list(
                OriginAccessIdentity = "string"
              ),
              CustomOriginConfig = list(
                HTTPPort = 123,
                HTTPSPort = 123,
                OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
                OriginSslProtocols = list(
                  Quantity = 123,
                  Items = list(
                    "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
                  )
                ),
                OriginReadTimeout = 123,
                OriginKeepaliveTimeout = 123
              ),
              ConnectionAttempts = 123,
              ConnectionTimeout = 123,
              OriginShield = list(
                Enabled = TRUE|FALSE,
                OriginShieldRegion = "string"
              )
            )
          )
        ),
        OriginGroups = list(
          Quantity = 123,
          Items = list(
            list(
              Id = "string",
              FailoverCriteria = list(
                StatusCodes = list(
                  Quantity = 123,
                  Items = list(
                    123
                  )
                )
              ),
              Members = list(
                Quantity = 123,
                Items = list(
                  list(
                    OriginId = "string"
                  )
                )
              )
            )
          )
        ),
        DefaultCacheBehavior = list(
          TargetOriginId = "string",
          TrustedSigners = list(
            Enabled = TRUE|FALSE,
            Quantity = 123,
            Items = list(
              "string"
            )
          ),
          TrustedKeyGroups = list(
            Enabled = TRUE|FALSE,
            Quantity = 123,
            Items = list(
              "string"
            )
          ),
          ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
          AllowedMethods = list(
            Quantity = 123,
            Items = list(
              "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
            ),
            CachedMethods = list(
              Quantity = 123,
              Items = list(
                "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
              )
            )
          ),
          SmoothStreaming = TRUE|FALSE,
          Compress = TRUE|FALSE,
          LambdaFunctionAssociations = list(
            Quantity = 123,
            Items = list(
              list(
                LambdaFunctionARN = "string",
                EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
                IncludeBody = TRUE|FALSE
              )
            )
          ),
          FieldLevelEncryptionId = "string",
          RealtimeLogConfigArn = "string",
          CachePolicyId = "string",
          OriginRequestPolicyId = "string",
          ForwardedValues = list(
            QueryString = TRUE|FALSE,
            Cookies = list(
              Forward = "none"|"whitelist"|"all",
              WhitelistedNames = list(
                Quantity = 123,
                Items = list(
                  "string"
                )
              )
            ),
            Headers = list(
              Quantity = 123,
              Items = list(
                "string"
              )
            ),
            QueryStringCacheKeys = list(
              Quantity = 123,
              Items = list(
                "string"
              )
            )
          ),
          MinTTL = 123,
          DefaultTTL = 123,
          MaxTTL = 123
        ),
        CacheBehaviors = list(
          Quantity = 123,
          Items = list(
            list(
              PathPattern = "string",
              TargetOriginId = "string",
              TrustedSigners = list(
                Enabled = TRUE|FALSE,
                Quantity = 123,
                Items = list(
                  "string"
                )
              ),
              TrustedKeyGroups = list(
                Enabled = TRUE|FALSE,
                Quantity = 123,
                Items = list(
                  "string"
                )
              ),
              ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
              AllowedMethods = list(
                Quantity = 123,
                Items = list(
                  "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
                ),
                CachedMethods = list(
                  Quantity = 123,
                  Items = list(
                    "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
                  )
                )
              ),
              SmoothStreaming = TRUE|FALSE,
              Compress = TRUE|FALSE,
              LambdaFunctionAssociations = list(
                Quantity = 123,
                Items = list(
                  list(
                    LambdaFunctionARN = "string",
                    EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
                    IncludeBody = TRUE|FALSE
                  )
                )
              ),
              FieldLevelEncryptionId = "string",
              RealtimeLogConfigArn = "string",
              CachePolicyId = "string",
              OriginRequestPolicyId = "string",
              ForwardedValues = list(
                QueryString = TRUE|FALSE,
                Cookies = list(
                  Forward = "none"|"whitelist"|"all",
                  WhitelistedNames = list(
                    Quantity = 123,
                    Items = list(
                      "string"
                    )
                  )
                ),
                Headers = list(
                  Quantity = 123,
                  Items = list(
                    "string"
                  )
                ),
                QueryStringCacheKeys = list(
                  Quantity = 123,
                  Items = list(
                    "string"
                  )
                )
              ),
              MinTTL = 123,
              DefaultTTL = 123,
              MaxTTL = 123
            )
          )
        ),
        CustomErrorResponses = list(
          Quantity = 123,
          Items = list(
            list(
              ErrorCode = 123,
              ResponsePagePath = "string",
              ResponseCode = "string",
              ErrorCachingMinTTL = 123
            )
          )
        ),
        Comment = "string",
        PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
        Enabled = TRUE|FALSE,
        ViewerCertificate = list(
          CloudFrontDefaultCertificate = TRUE|FALSE,
          IAMCertificateId = "string",
          ACMCertificateArn = "string",
          SSLSupportMethod = "sni-only"|"vip"|"static-ip",
          MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018"|"TLSv1.2_2019",
          Certificate = "string",
          CertificateSource = "cloudfront"|"iam"|"acm"
        ),
        Restrictions = list(
          GeoRestriction = list(
            RestrictionType = "blacklist"|"whitelist"|"none",
            Quantity = 123,
            Items = list(
              "string"
            )
          )
        ),
        WebACLId = "string",
        HttpVersion = "http1.1"|"http2",
        IsIPV6Enabled = TRUE|FALSE,
        AliasICPRecordals = list(
          list(
            CNAME = "string",
            ICPRecordalStatus = "APPROVED"|"SUSPENDED"|"PENDING"
          )
        )
      )
    )
  )
)
}
}
\description{
Gets a list of distributions that have a cache behavior that’s
associated with the specified real-time log configuration.

You can specify the real-time log configuration by its name or its
Amazon Resource Name (ARN). You must provide at least one. If you
provide both, CloudFront uses the name to identify the real-time log
configuration to list distributions for.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_realtime_log_config(
  Marker = "string",
  MaxItems = "string",
  RealtimeLogConfigName = "string",
  RealtimeLogConfigArn = "string"
)
}
}

\keyword{internal}
