% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_allocate_transit_virtual_interface}
\alias{directconnect_allocate_transit_virtual_interface}
\title{Provisions a transit virtual interface to be owned by the specified AWS
account}
\usage{
directconnect_allocate_transit_virtual_interface(connectionId,
  ownerAccount, newTransitVirtualInterfaceAllocation)
}
\arguments{
\item{connectionId}{[required] The ID of the connection on which the transit virtual interface is
provisioned.}

\item{ownerAccount}{[required] The ID of the AWS account that owns the transit virtual interface.}

\item{newTransitVirtualInterfaceAllocation}{[required] Information about the transit virtual interface.}
}
\description{
Provisions a transit virtual interface to be owned by the specified AWS
account. Use this type of interface to connect a transit gateway to your
Direct Connect gateway.

The owner of a connection provisions a transit virtual interface to be
owned by the specified AWS account.

After you create a transit virtual interface, it must be confirmed by
the owner using ConfirmTransitVirtualInterface. Until this step has been
completed, the transit virtual interface is in the \code{requested} state and
is not available to handle traffic.
}
\section{Request syntax}{
\preformatted{svc$allocate_transit_virtual_interface(
  connectionId = "string",
  ownerAccount = "string",
  newTransitVirtualInterfaceAllocation = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    mtu = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
