% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_update_kx_cluster_code_configuration}
\alias{finspace_update_kx_cluster_code_configuration}
\title{Allows you to update code configuration on a running cluster}
\usage{
finspace_update_kx_cluster_code_configuration(
  environmentId,
  clusterName,
  clientToken = NULL,
  code,
  initializationScript = NULL,
  commandLineArguments = NULL,
  deploymentConfiguration = NULL
)
}
\arguments{
\item{environmentId}{[required] A unique identifier of the kdb environment.}

\item{clusterName}{[required] The name of the cluster.}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{code}{[required]}

\item{initializationScript}{Specifies a Q program that will be run at launch of a cluster. It is a
relative path within \emph{.zip} file that contains the custom code, which
will be loaded on the cluster. It must include the file name itself. For
example, \code{somedir/init.q}.

You cannot update this parameter for a \code{NO_RESTART} deployment.}

\item{commandLineArguments}{Specifies the key-value pairs to make them available inside the cluster.

You cannot update this parameter for a \code{NO_RESTART} deployment.}

\item{deploymentConfiguration}{The configuration that allows you to choose how you want to update the
code on a cluster.}
}
\description{
Allows you to update code configuration on a running cluster. By using this API you can update the code, the initialization script path, and the command line arguments for a specific cluster. The configuration that you want to update will override any existing configurations on the cluster.

See \url{https://www.paws-r-sdk.com/docs/finspace_update_kx_cluster_code_configuration/} for full documentation.
}
\keyword{internal}
