# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' CloudWatch RUM
#'
#' @description
#' With Amazon CloudWatch RUM, you can perform real-user monitoring to
#' collect client-side data about your web application performance from
#' actual user sessions in real time. The data collected includes page load
#' times, client-side errors, and user behavior. When you view this data,
#' you can see it all aggregated together and also see breakdowns by the
#' browsers and devices that your customers use.
#' 
#' You can use the collected data to quickly identify and debug client-side
#' performance issues. CloudWatch RUM helps you visualize anomalies in your
#' application performance and find relevant debugging data such as error
#' messages, stack traces, and user sessions. You can also use RUM to
#' understand the range of end-user impact including the number of users,
#' geolocations, and browsers used.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- cloudwatchrum(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudwatchrum()
#' svc$batch_create_rum_metric_definitions(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudwatchrum_batch_create_rum_metric_definitions]{batch_create_rum_metric_definitions} \tab Specifies the extended metrics and custom metrics that you want a CloudWatch RUM app monitor to send to a destination\cr
#'  \link[=cloudwatchrum_batch_delete_rum_metric_definitions]{batch_delete_rum_metric_definitions} \tab Removes the specified metrics from being sent to an extended metrics destination\cr
#'  \link[=cloudwatchrum_batch_get_rum_metric_definitions]{batch_get_rum_metric_definitions} \tab Retrieves the list of metrics and dimensions that a RUM app monitor is sending to a single destination\cr
#'  \link[=cloudwatchrum_create_app_monitor]{create_app_monitor} \tab Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM\cr
#'  \link[=cloudwatchrum_delete_app_monitor]{delete_app_monitor} \tab Deletes an existing app monitor\cr
#'  \link[=cloudwatchrum_delete_rum_metrics_destination]{delete_rum_metrics_destination} \tab Deletes a destination for CloudWatch RUM extended metrics, so that the specified app monitor stops sending extended metrics to that destination\cr
#'  \link[=cloudwatchrum_get_app_monitor]{get_app_monitor} \tab Retrieves the complete configuration information for one app monitor\cr
#'  \link[=cloudwatchrum_get_app_monitor_data]{get_app_monitor_data} \tab Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data\cr
#'  \link[=cloudwatchrum_list_app_monitors]{list_app_monitors} \tab Returns a list of the Amazon CloudWatch RUM app monitors in the account\cr
#'  \link[=cloudwatchrum_list_rum_metrics_destinations]{list_rum_metrics_destinations} \tab Returns a list of destinations that you have created to receive RUM extended metrics, for the specified app monitor\cr
#'  \link[=cloudwatchrum_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a CloudWatch RUM resource\cr
#'  \link[=cloudwatchrum_put_rum_events]{put_rum_events} \tab Sends telemetry events about your application performance and user behavior to CloudWatch RUM\cr
#'  \link[=cloudwatchrum_put_rum_metrics_destination]{put_rum_metrics_destination} \tab Creates or updates a destination to receive extended metrics from CloudWatch RUM\cr
#'  \link[=cloudwatchrum_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource\cr
#'  \link[=cloudwatchrum_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=cloudwatchrum_update_app_monitor]{update_app_monitor} \tab Updates the configuration of an existing app monitor\cr
#'  \link[=cloudwatchrum_update_rum_metric_definition]{update_rum_metric_definition} \tab Modifies one existing metric definition for CloudWatch RUM extended metrics
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudwatchrum
#' @export
cloudwatchrum <- function(config = list()) {
  svc <- .cloudwatchrum$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudwatchrum <- list()

.cloudwatchrum$operations <- list()

.cloudwatchrum$metadata <- list(
  service_name = "cloudwatchrum",
  endpoints = list("*" = list(endpoint = "rum.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "rum.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "rum.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "rum.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "RUM",
  api_version = "2018-05-10",
  signing_name = "rum",
  json_version = "1.1",
  target_prefix = ""
)

.cloudwatchrum$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.cloudwatchrum$metadata, handlers, config)
}
