% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_patch_baseline}
\alias{ssm_update_patch_baseline}
\title{Modifies an existing patch baseline}
\usage{
ssm_update_patch_baseline(BaselineId, Name, GlobalFilters,
  ApprovalRules, ApprovedPatches, ApprovedPatchesComplianceLevel,
  ApprovedPatchesEnableNonSecurity, RejectedPatches,
  RejectedPatchesAction, Description, Sources, Replace)
}
\arguments{
\item{BaselineId}{[required] The ID of the patch baseline to update.}

\item{Name}{The name of the patch baseline.}

\item{GlobalFilters}{A set of global filters used to include patches in the baseline.}

\item{ApprovalRules}{A set of rules used to include patches in the baseline.}

\item{ApprovedPatches}{A list of explicitly approved patches for the baseline.

For information about accepted formats for lists of approved patches and
rejected patches, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html}{About package name formats for approved and rejected patch lists}
in the \emph{AWS Systems Manager User Guide}.}

\item{ApprovedPatchesComplianceLevel}{Assigns a new compliance severity level to an existing patch baseline.}

\item{ApprovedPatchesEnableNonSecurity}{Indicates whether the list of approved patches includes non-security
updates that should be applied to the instances. The default value is
\'false\'. Applies to Linux instances only.}

\item{RejectedPatches}{A list of explicitly rejected patches for the baseline.

For information about accepted formats for lists of approved patches and
rejected patches, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html}{About package name formats for approved and rejected patch lists}
in the \emph{AWS Systems Manager User Guide}.}

\item{RejectedPatchesAction}{The action for Patch Manager to take on patches included in the
RejectedPackages list.
\itemize{
\item \strong{ALLOW\\_AS\\_DEPENDENCY}: A package in the Rejected patches list is
installed only if it is a dependency of another package. It is
considered compliant with the patch baseline, and its status is
reported as \emph{InstalledOther}. This is the default action if no
option is specified.
\item \strong{BLOCK}: Packages in the RejectedPatches list, and packages that
include them as dependencies, are not installed under any
circumstances. If a package was installed before it was added to the
Rejected patches list, it is considered non-compliant with the patch
baseline, and its status is reported as \emph{InstalledRejected}.
}}

\item{Description}{A description of the patch baseline.}

\item{Sources}{Information about the patches to use to update the instances, including
target operating systems and source repositories. Applies to Linux
instances only.}

\item{Replace}{If True, then all fields that are required by the CreatePatchBaseline
action are also required for this API request. Optional fields that are
not specified are set to null.}
}
\description{
Modifies an existing patch baseline. Fields not specified in the request
are left unchanged.
}
\details{
For information about valid key and value pairs in \code{PatchFilters} for
each supported operating system type, see
\href{http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html}{PatchFilter}.
}
\section{Request syntax}{
\preformatted{svc$update_patch_baseline(
  BaselineId = "string",
  Name = "string",
  GlobalFilters = list(
    PatchFilters = list(
      list(
        Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
        Values = list(
          "string"
        )
      )
    )
  ),
  ApprovalRules = list(
    PatchRules = list(
      list(
        PatchFilterGroup = list(
          PatchFilters = list(
            list(
              Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
              Values = list(
                "string"
              )
            )
          )
        ),
        ComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
        ApproveAfterDays = 123,
        ApproveUntilDate = "string",
        EnableNonSecurity = TRUE|FALSE
      )
    )
  ),
  ApprovedPatches = list(
    "string"
  ),
  ApprovedPatchesComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
  ApprovedPatchesEnableNonSecurity = TRUE|FALSE,
  RejectedPatches = list(
    "string"
  ),
  RejectedPatchesAction = "ALLOW_AS_DEPENDENCY"|"BLOCK",
  Description = "string",
  Sources = list(
    list(
      Name = "string",
      Products = list(
        "string"
      ),
      Configuration = "string"
    )
  ),
  Replace = TRUE|FALSE
)
}
}

\keyword{internal}
