% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_create_organizational_unit}
\alias{organizations_create_organizational_unit}
\title{Creates an organizational unit (OU) within a root or parent OU}
\usage{
organizations_create_organizational_unit(ParentId, Name)
}
\arguments{
\item{ParentId}{[required] The unique identifier (ID) of the parent root or OU that you want to
create the new OU in.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a parent ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with \"r-\" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Organizational unit (OU)} - A string that begins with \"ou-\"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second \"-\"
dash and from 8 to 32 additional lowercase letters or digits.
}}

\item{Name}{[required] The friendly name to assign to the new OU.}
}
\description{
Creates an organizational unit (OU) within a root or parent OU. An OU is
a container for accounts that enables you to organize your accounts to
apply policies according to your business requirements. The number of
levels deep that you can nest OUs is dependent upon the policy types
enabled for that root. For service control policies, the limit is five.
}
\details{
For more information about OUs, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html}{Managing Organizational Units}
in the \emph{AWS Organizations User Guide.}

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$create_organizational_unit(
  ParentId = "string",
  Name = "string"
)
}
}

\examples{
\dontrun{
# The following example shows how to create an OU that is named
# AccountingOU. The new OU is directly under the root.:
# 
# 
svc$create_organizational_unit(
  Name = "AccountingOU",
  ParentId = "r-examplerootid111"
)
}

}
\keyword{internal}
