% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_send_command}
\alias{ssm_send_command}
\title{Runs commands on one or more managed instances}
\usage{
ssm_send_command(InstanceIds, Targets, DocumentName, DocumentVersion,
  DocumentHash, DocumentHashType, TimeoutSeconds, Comment, Parameters,
  OutputS3Region, OutputS3BucketName, OutputS3KeyPrefix, MaxConcurrency,
  MaxErrors, ServiceRoleArn, NotificationConfig, CloudWatchOutputConfig)
}
\arguments{
\item{InstanceIds}{The IDs of the instances where the command should run. Specifying
instance IDs is most useful when you are targeting a limited number of
instances, though you can specify up to 50 IDs.

To target a larger number of instances, or if you prefer not to list
individual instance IDs, we recommend using the \code{Targets} option
instead. Using \code{Targets}, which accepts tag key-value pairs to identify
the instances to send commands to, you can a send command to tens,
hundreds, or thousands of instances at once.

For more information about how to use targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html}{Using targets and rate controls to send commands to a fleet}
in the \emph{AWS Systems Manager User Guide}.}

\item{Targets}{An array of search criteria that targets instances using a \verb{Key,Value}
combination that you specify. Specifying targets is most useful when you
want to send a command to a large number of instances at once. Using
\code{Targets}, which accepts tag key-value pairs to identify instances, you
can send a command to tens, hundreds, or thousands of instances at once.

To send a command to a smaller number of instances, you can use the
\code{InstanceIds} option instead.

For more information about how to use targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html}{Sending commands to a fleet}
in the \emph{AWS Systems Manager User Guide}.}

\item{DocumentName}{[required] Required. The name of the Systems Manager document to run. This can be a
public document or a custom document.}

\item{DocumentVersion}{The SSM document version to use in the request. You can specify
$DEFAULT, $LATEST, or a specific version number. If you run commands by
using the AWS CLI, then you must escape the first two options by using a
backslash. If you specify a version number, then you don't need to use
the backslash. For example:

--document-version "\\$DEFAULT"

--document-version "\\$LATEST"

--document-version "3"}

\item{DocumentHash}{The Sha256 or Sha1 hash created by the system when the document was
created.

Sha1 hashes have been deprecated.}

\item{DocumentHashType}{Sha256 or Sha1.

Sha1 hashes have been deprecated.}

\item{TimeoutSeconds}{If this time is reached and the command has not already started running,
it will not run.}

\item{Comment}{User-specified information about the command, such as a brief
description of what the command should do.}

\item{Parameters}{The required and optional parameters specified in the document being
run.}

\item{OutputS3Region}{(Deprecated) You can no longer specify this parameter. The system
ignores it. Instead, Systems Manager automatically determines the Region
of the S3 bucket.}

\item{OutputS3BucketName}{The name of the S3 bucket where command execution responses should be
stored.}

\item{OutputS3KeyPrefix}{The directory structure within the S3 bucket where the responses should
be stored.}

\item{MaxConcurrency}{(Optional) The maximum number of instances that are allowed to run the
command at the same time. You can specify a number such as 10 or a
percentage such as 10\%. The default value is 50. For more information
about how to use MaxConcurrency, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity}{Using concurrency controls}
in the \emph{AWS Systems Manager User Guide}.}

\item{MaxErrors}{The maximum number of errors allowed without the command failing. When
the command fails one more time beyond the value of MaxErrors, the
systems stops sending the command to additional targets. You can specify
a number like 10 or a percentage like 10\%. The default value is 0. For
more information about how to use MaxErrors, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors}{Using error controls}
in the \emph{AWS Systems Manager User Guide}.}

\item{ServiceRoleArn}{The ARN of the IAM service role to use to publish Amazon Simple
Notification Service (Amazon SNS) notifications for Run Command
commands.}

\item{NotificationConfig}{Configurations for sending notifications.}

\item{CloudWatchOutputConfig}{Enables Systems Manager to send Run Command output to Amazon CloudWatch
Logs.}
}
\description{
Runs commands on one or more managed instances.
}
\section{Request syntax}{
\preformatted{svc$send_command(
  InstanceIds = list(
    "string"
  ),
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  DocumentName = "string",
  DocumentVersion = "string",
  DocumentHash = "string",
  DocumentHashType = "Sha256"|"Sha1",
  TimeoutSeconds = 123,
  Comment = "string",
  Parameters = list(
    list(
      "string"
    )
  ),
  OutputS3Region = "string",
  OutputS3BucketName = "string",
  OutputS3KeyPrefix = "string",
  MaxConcurrency = "string",
  MaxErrors = "string",
  ServiceRoleArn = "string",
  NotificationConfig = list(
    NotificationArn = "string",
    NotificationEvents = list(
      "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
    ),
    NotificationType = "Command"|"Invocation"
  ),
  CloudWatchOutputConfig = list(
    CloudWatchLogGroupName = "string",
    CloudWatchOutputEnabled = TRUE|FALSE
  )
)
}
}

\keyword{internal}
