% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_put_compliance_items}
\alias{ssm_put_compliance_items}
\title{Registers a compliance type and other compliance details on a designated
resource}
\usage{
ssm_put_compliance_items(ResourceId, ResourceType, ComplianceType,
  ExecutionSummary, Items, ItemContentHash, UploadType)
}
\arguments{
\item{ResourceId}{[required] Specify an ID for this resource. For a managed instance, this is the
instance ID.}

\item{ResourceType}{[required] Specify the type of resource. \code{ManagedInstance} is currently the only
supported resource type.}

\item{ComplianceType}{[required] Specify the compliance type. For example, specify Association (for a
State Manager association), Patch, or Custom:\code{string}.}

\item{ExecutionSummary}{[required] A summary of the call execution that includes an execution ID, the type
of execution (for example, \code{Command}), and the date/time of the
execution using a datetime object that is saved in the following format:
yyyy-MM-dd'T'HH:mm:ss'Z'.}

\item{Items}{[required] Information about the compliance as defined by the resource type. For
example, for a patch compliance type, \code{Items} includes information about
the PatchSeverity, Classification, and so on.}

\item{ItemContentHash}{MD5 or SHA-256 content hash. The content hash is used to determine if
existing information should be overwritten or ignored. If the content
hashes match, the request to put compliance information is ignored.}

\item{UploadType}{The mode for uploading compliance items. You can specify \code{COMPLETE} or
\code{PARTIAL}. In \code{COMPLETE} mode, the system overwrites all existing
compliance information for the resource. You must provide a full list of
compliance items each time you send the request.

In \code{PARTIAL} mode, the system overwrites compliance information for a
specific association. The association must be configured with
\code{SyncCompliance} set to \code{MANUAL}. By default, all requests use
\code{COMPLETE} mode.

This attribute is only valid for association compliance.}
}
\description{
Registers a compliance type and other compliance details on a designated
resource. This action lets you register custom compliance details with a
resource. This call overwrites existing compliance information on the
resource, so you must provide a full list of compliance items each time
that you send the request.

ComplianceType can be one of the following:
\itemize{
\item ExecutionId: The execution ID when the patch, association, or custom
compliance item was applied.
\item ExecutionType: Specify patch, association, or Custom:\code{string}.
\item ExecutionTime. The time the patch, association, or custom compliance
item was applied to the instance.
\item Id: The patch, association, or custom compliance ID.
\item Title: A title.
\item Status: The status of the compliance item. For example, \code{approved}
for patches, or \code{Failed} for associations.
\item Severity: A patch severity. For example, \code{critical}.
\item DocumentName: A SSM document name. For example,
AWS-RunPatchBaseline.
\item DocumentVersion: An SSM document version number. For example, 4.
\item Classification: A patch classification. For example,
\verb{security updates}.
\item PatchBaselineId: A patch baseline ID.
\item PatchSeverity: A patch severity. For example, \code{Critical}.
\item PatchState: A patch state. For example,
\code{InstancesWithFailedPatches}.
\item PatchGroup: The name of a patch group.
\item InstalledTime: The time the association, patch, or custom compliance
item was applied to the resource. Specify the time by using the
following format: yyyy-MM-dd'T'HH:mm:ss'Z'
}
}
\section{Request syntax}{
\preformatted{svc$put_compliance_items(
  ResourceId = "string",
  ResourceType = "string",
  ComplianceType = "string",
  ExecutionSummary = list(
    ExecutionTime = as.POSIXct(
      "2015-01-01"
    ),
    ExecutionId = "string",
    ExecutionType = "string"
  ),
  Items = list(
    list(
      Id = "string",
      Title = "string",
      Severity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
      Status = "COMPLIANT"|"NON_COMPLIANT",
      Details = list(
        "string"
      )
    )
  ),
  ItemContentHash = "string",
  UploadType = "COMPLETE"|"PARTIAL"
)
}
}

\keyword{internal}
