% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_restore_server}
\alias{opsworkscm_restore_server}
\title{Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY,
RUNNING, UNHEALTHY, or TERMINATED state}
\usage{
opsworkscm_restore_server(BackupId, ServerName, InstanceType, KeyPair)
}
\arguments{
\item{BackupId}{[required] The ID of the backup that you want to use to restore a server.}

\item{ServerName}{[required] The name of the server that you want to restore.}

\item{InstanceType}{The type of the instance to create. Valid values must be specified in
the following format: \code{^(\\[cm\\]\\[34\\]|t2).*} For example,
\code{m4.large}. Valid values are \code{t2.medium}, \code{m4.large}, and \code{m4.2xlarge}.
If you do not specify this parameter, RestoreServer uses the instance
type from the specified backup.}

\item{KeyPair}{The name of the key pair to set on the new EC2 instance. This can be
helpful if the administrator no longer has the SSH key.}
}
\description{
Restores a backup to a server that is in a \code{CONNECTION_LOST}, \code{HEALTHY},
\code{RUNNING}, \code{UNHEALTHY}, or \code{TERMINATED} state. When you run
RestoreServer, the server's EC2 instance is deleted, and a new EC2
instance is configured. RestoreServer maintains the existing server
endpoint, so configuration management of the server's client devices
(nodes) should continue to work.
}
\details{
This operation is asynchronous.

An \code{InvalidStateException} is thrown when the server is not in a valid
state. A \code{ResourceNotFoundException} is thrown when the server does not
exist. A \code{ValidationException} is raised when parameters of the request
are not valid.
}
\section{Request syntax}{
\preformatted{svc$restore_server(
  BackupId = "string",
  ServerName = "string",
  InstanceType = "string",
  KeyPair = "string"
)
}
}

\keyword{internal}
