% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_explainabilities}
\alias{forecastservice_list_explainabilities}
\title{Returns a list of Explainability resources created using the
CreateExplainability operation}
\usage{
forecastservice_list_explainabilities(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a NextToken. To retrieve the next set of results, use the token
in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The number of items returned in the response.}

\item{Filters}{An array of filters. For each filter, provide a condition and a match
statement. The condition is either \code{IS} or \code{IS_NOT}, which specifies
whether to include or exclude the resources that match the statement
from the list. The match statement consists of a key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. Valid values are
\code{ResourceArn} and \code{Status}.
\item \code{Value} - The value to match.
}}
}
\description{
Returns a list of Explainability resources created using the \code{\link[=forecastservice_create_explainability]{create_explainability}} operation. This operation returns a summary for each Explainability. You can filter the list using an array of Filter objects.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_list_explainabilities/} for full documentation.
}
\keyword{internal}
