# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Transcribe Service
#'
#' @description
#' Amazon Transcribe offers three main types of batch transcription:
#' **Standard**, **Medical**, and **Call Analytics**.
#' 
#' -   **Standard transcriptions** are the most common option. Refer to for
#'     details.
#' 
#' -   **Medical transcriptions** are tailored to medical professionals and
#'     incorporate medical terms. A common use case for this service is
#'     transcribing doctor-patient dialogue into after-visit notes. Refer
#'     to for details.
#' 
#' -   **Call Analytics transcriptions** are designed for use with call
#'     center audio on two different channels; if you're looking for
#'     insight into customer service calls, use this option. Refer to for
#'     details.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- transcribeservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- transcribeservice()
#' svc$create_call_analytics_category(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=transcribeservice_create_call_analytics_category]{create_call_analytics_category} \tab Creates a new Call Analytics category\cr
#'  \link[=transcribeservice_create_language_model]{create_language_model} \tab Creates a new custom language model\cr
#'  \link[=transcribeservice_create_medical_vocabulary]{create_medical_vocabulary} \tab Creates a new custom medical vocabulary\cr
#'  \link[=transcribeservice_create_vocabulary]{create_vocabulary} \tab Creates a new custom vocabulary\cr
#'  \link[=transcribeservice_create_vocabulary_filter]{create_vocabulary_filter} \tab Creates a new custom vocabulary filter\cr
#'  \link[=transcribeservice_delete_call_analytics_category]{delete_call_analytics_category} \tab Deletes a Call Analytics category\cr
#'  \link[=transcribeservice_delete_call_analytics_job]{delete_call_analytics_job} \tab Deletes a Call Analytics job\cr
#'  \link[=transcribeservice_delete_language_model]{delete_language_model} \tab Deletes a custom language model\cr
#'  \link[=transcribeservice_delete_medical_transcription_job]{delete_medical_transcription_job} \tab Deletes a medical transcription job\cr
#'  \link[=transcribeservice_delete_medical_vocabulary]{delete_medical_vocabulary} \tab Deletes a custom medical vocabulary\cr
#'  \link[=transcribeservice_delete_transcription_job]{delete_transcription_job} \tab Deletes a transcription job\cr
#'  \link[=transcribeservice_delete_vocabulary]{delete_vocabulary} \tab Deletes a custom vocabulary\cr
#'  \link[=transcribeservice_delete_vocabulary_filter]{delete_vocabulary_filter} \tab Deletes a custom vocabulary filter\cr
#'  \link[=transcribeservice_describe_language_model]{describe_language_model} \tab Provides information about the specified custom language model\cr
#'  \link[=transcribeservice_get_call_analytics_category]{get_call_analytics_category} \tab Provides information about the specified Call Analytics category\cr
#'  \link[=transcribeservice_get_call_analytics_job]{get_call_analytics_job} \tab Provides information about the specified Call Analytics job\cr
#'  \link[=transcribeservice_get_medical_transcription_job]{get_medical_transcription_job} \tab Provides information about the specified medical transcription job\cr
#'  \link[=transcribeservice_get_medical_vocabulary]{get_medical_vocabulary} \tab Provides information about the specified custom medical vocabulary\cr
#'  \link[=transcribeservice_get_transcription_job]{get_transcription_job} \tab Provides information about the specified transcription job\cr
#'  \link[=transcribeservice_get_vocabulary]{get_vocabulary} \tab Provides information about the specified custom vocabulary\cr
#'  \link[=transcribeservice_get_vocabulary_filter]{get_vocabulary_filter} \tab Provides information about the specified custom vocabulary filter\cr
#'  \link[=transcribeservice_list_call_analytics_categories]{list_call_analytics_categories} \tab Provides a list of Call Analytics categories, including all rules that make up each category\cr
#'  \link[=transcribeservice_list_call_analytics_jobs]{list_call_analytics_jobs} \tab Provides a list of Call Analytics jobs that match the specified criteria\cr
#'  \link[=transcribeservice_list_language_models]{list_language_models} \tab Provides a list of custom language models that match the specified criteria\cr
#'  \link[=transcribeservice_list_medical_transcription_jobs]{list_medical_transcription_jobs} \tab Provides a list of medical transcription jobs that match the specified criteria\cr
#'  \link[=transcribeservice_list_medical_vocabularies]{list_medical_vocabularies} \tab Provides a list of custom medical vocabularies that match the specified criteria\cr
#'  \link[=transcribeservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with the specified transcription job, vocabulary, model, or resource\cr
#'  \link[=transcribeservice_list_transcription_jobs]{list_transcription_jobs} \tab Provides a list of transcription jobs that match the specified criteria\cr
#'  \link[=transcribeservice_list_vocabularies]{list_vocabularies} \tab Provides a list of custom vocabularies that match the specified criteria\cr
#'  \link[=transcribeservice_list_vocabulary_filters]{list_vocabulary_filters} \tab Provides a list of custom vocabulary filters that match the specified criteria\cr
#'  \link[=transcribeservice_start_call_analytics_job]{start_call_analytics_job} \tab Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request\cr
#'  \link[=transcribeservice_start_medical_transcription_job]{start_medical_transcription_job} \tab Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request\cr
#'  \link[=transcribeservice_start_transcription_job]{start_transcription_job} \tab Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request\cr
#'  \link[=transcribeservice_tag_resource]{tag_resource} \tab Adds one or more custom tags, each in the form of a key:value pair, to the specified resource\cr
#'  \link[=transcribeservice_untag_resource]{untag_resource} \tab Removes the specified tags from the specified Amazon Transcribe resource\cr
#'  \link[=transcribeservice_update_call_analytics_category]{update_call_analytics_category} \tab Updates the specified Call Analytics category with new rules\cr
#'  \link[=transcribeservice_update_medical_vocabulary]{update_medical_vocabulary} \tab Updates an existing custom medical vocabulary with new values\cr
#'  \link[=transcribeservice_update_vocabulary]{update_vocabulary} \tab Updates an existing custom vocabulary with new values\cr
#'  \link[=transcribeservice_update_vocabulary_filter]{update_vocabulary_filter} \tab Updates an existing custom vocabulary filter with a new list of words
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname transcribeservice
#' @export
transcribeservice <- function(config = list()) {
  svc <- .transcribeservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.transcribeservice <- list()

.transcribeservice$operations <- list()

.transcribeservice$metadata <- list(
  service_name = "transcribe",
  endpoints = list("*" = list(endpoint = "transcribe.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "transcribe.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "transcribe.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "transcribe.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Transcribe",
  api_version = "2017-10-26",
  signing_name = "transcribe",
  json_version = "1.1",
  target_prefix = "Transcribe"
)

.transcribeservice$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.transcribeservice$metadata, handlers, config)
}
