% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerruntime_operations.R
\name{sagemakerruntime_invoke_endpoint_async}
\alias{sagemakerruntime_invoke_endpoint_async}
\title{After you deploy a model into production using Amazon SageMaker hosting
services, your client applications use this API to get inferences from
the model hosted at the specified endpoint in an asynchronous manner}
\usage{
sagemakerruntime_invoke_endpoint_async(
  EndpointName,
  ContentType = NULL,
  Accept = NULL,
  CustomAttributes = NULL,
  InferenceId = NULL,
  InputLocation,
  RequestTTLSeconds = NULL
)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint that you specified when you created the
endpoint using the
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html}{\code{CreateEndpoint}}
API.}

\item{ContentType}{The MIME type of the input data in the request body.}

\item{Accept}{The desired MIME type of the inference in the response.}

\item{CustomAttributes}{Provides additional information about a request for an inference
submitted to a model hosted at an Amazon SageMaker endpoint. The
information is an opaque value that is forwarded verbatim. You could use
this value, for example, to provide an ID that you can use to track a
request or to provide other metadata that a service endpoint was
programmed to process. The value must consist of no more than 1024
visible US-ASCII characters as specified in \href{https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6}{Section 3.3.6. Field Value Components}
of the Hypertext Transfer Protocol (HTTP/1.1).

The code in your model is responsible for setting or updating any custom
attributes in the response. If your code does not set this value in the
response, an empty value is returned. For example, if a custom attribute
represents the trace ID, your model can prepend the custom attribute
with \verb{Trace ID}: in your post-processing function.

This feature is currently supported in the Amazon Web Services SDKs but
not in the Amazon SageMaker Python SDK.}

\item{InferenceId}{The identifier for the inference request. Amazon SageMaker will generate
an identifier for you if none is specified.}

\item{InputLocation}{[required] The Amazon S3 URI where the inference request payload is stored.}

\item{RequestTTLSeconds}{Maximum age in seconds a request can be in the queue before it is marked
as expired.}
}
\description{
After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint in an asynchronous manner.

See \url{https://paws-r.github.io/docs/sagemakerruntime/invoke_endpoint_async.html} for full documentation.
}
\keyword{internal}
