% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_workforce}
\alias{sagemaker_update_workforce}
\title{Restricts access to tasks assigned to workers in the specified workforce
to those within specific ranges of IP addresses}
\usage{
sagemaker_update_workforce(WorkforceName, SourceIpConfig)
}
\arguments{
\item{WorkforceName}{[required] The name of the private workforce whose access you want to restrict.
\code{WorkforceName} is automatically set to \code{default} when a workforce is
created and cannot be modified.}

\item{SourceIpConfig}{A list of one to ten worker IP address ranges
(\href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html}{CIDRs})
that can be used to access tasks assigned to this workforce.

Maximum: Ten CIDR values}
}
\description{
Restricts access to tasks assigned to workers in the specified workforce
to those within specific ranges of IP addresses. You specify allowed IP
addresses by creating a list of up to ten
\href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html}{CIDRs}.
}
\details{
By default, a workforce isn\'t restricted to specific IP addresses. If
you specify a range of IP addresses, workers who attempt to access tasks
using any IP address outside the specified range are denied access and
get a \verb{Not Found} error message on the worker portal. After restricting
access with this operation, you can see the allowed IP values for a
private workforce with the operation.

This operation applies only to private workforces.
}
\section{Request syntax}{
\preformatted{svc$update_workforce(
  WorkforceName = "string",
  SourceIpConfig = list(
    Cidrs = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
