% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_document_classifier}
\alias{comprehend_create_document_classifier}
\title{Creates a new document classifier that you can use to categorize
documents}
\usage{
comprehend_create_document_classifier(DocumentClassifierName,
  DataAccessRoleArn, Tags, InputDataConfig, OutputDataConfig,
  ClientRequestToken, LanguageCode, VolumeKmsKeyId, VpcConfig, Mode)
}
\arguments{
\item{DocumentClassifierName}{[required] The name of the document classifier.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
role that grants Amazon Comprehend read access to your input data.}

\item{Tags}{Tags to be associated with the document classifier being created. A tag
is a key-value pair that adds as a metadata to a resource used by Amazon
Comprehend. For example, a tag with \"Sales\" as the key might be added
to a resource to indicate its use by the sales department.}

\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{Enables the addition of output results configuration parameters for
custom classifier jobs.}

\item{ClientRequestToken}{A unique identifier for the request. If you don\'t set the client
request token, Amazon Comprehend generates one.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the
following languages supported by Amazon Comprehend: German (\"de\"),
English (\"en\"), Spanish (\"es\"), French (\"fr\"), Italian (\"it\"),
or Portuguese (\"pt\"). All documents must be in the same language.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{Configuration parameters for an optional private Virtual Private Cloud
(VPC) containing the resources you are using for your custom classifier.
For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html}{Amazon VPC}.}

\item{Mode}{Indicates the mode in which the classifier will be trained. The
classifier can be trained in multi-class mode, which identifies one and
only one class for each document, or multi-label mode, which identifies
one or more labels for each document. In multi-label mode, multiple
labels for an individual document are separated by a delimiter. The
default delimiter between labels is a pipe (\\|).}
}
\description{
Creates a new document classifier that you can use to categorize
documents. To create a classifier, you provide a set of training
documents that labeled with the categories that you want to use. After
the classifier is trained you can use it to categorize a set of labeled
documents into the categories. For more information, see
how-document-classification.
}
\section{Request syntax}{
\preformatted{svc$create_document_classifier(
  DocumentClassifierName = "string",
  DataAccessRoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  InputDataConfig = list(
    S3Uri = "string",
    LabelDelimiter = "string"
  ),
  OutputDataConfig = list(
    S3Uri = "string",
    KmsKeyId = "string"
  ),
  ClientRequestToken = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
  VolumeKmsKeyId = "string",
  VpcConfig = list(
    SecurityGroupIds = list(
      "string"
    ),
    Subnets = list(
      "string"
    )
  ),
  Mode = "MULTI_CLASS"|"MULTI_LABEL"
)
}
}

\keyword{internal}
