% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_render_ui_template}
\alias{sagemaker_render_ui_template}
\title{Renders the UI template so that you can preview the worker's experience}
\usage{
sagemaker_render_ui_template(UiTemplate, Task, RoleArn)
}
\arguments{
\item{UiTemplate}{[required] A \code{Template} object containing the worker UI template to render.}

\item{Task}{[required] A \code{RenderableTask} object containing a representative task to render.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) that has access to the S3 objects that
are used by the template.}
}
\description{
Renders the UI template so that you can preview the worker\'s
experience.
}
\section{Request syntax}{
\preformatted{svc$render_ui_template(
  UiTemplate = list(
    Content = "string"
  ),
  Task = list(
    Input = "string"
  ),
  RoleArn = "string"
)
}
}

\keyword{internal}
