% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset_group}
\alias{personalize_create_dataset_group}
\title{Creates an empty dataset group}
\usage{
personalize_create_dataset_group(name, roleArn, kmsKeyArn)
}
\arguments{
\item{name}{[required] The name for the new dataset group.}

\item{roleArn}{The ARN of the IAM role that has permissions to access the KMS key.
Supplying an IAM role is only valid when also specifying a KMS key.}

\item{kmsKeyArn}{The Amazon Resource Name (ARN) of a KMS key used to encrypt the
datasets.}
}
\description{
Creates an empty dataset group. A dataset group contains related
datasets that supply data for training a model. A dataset group can
contain at most three datasets, one for each type of dataset:
}
\details{
\itemize{
\item Interactions
\item Items
\item Users
}

To train a model (create a solution), a dataset group that contains an
\code{Interactions} dataset is required. Call CreateDataset to add a dataset
to the group.

A dataset group can be in one of the following states:
\itemize{
\item CREATE PENDING \\> CREATE IN\\_PROGRESS \\> ACTIVE -or- CREATE FAILED
\item DELETE PENDING
}

To get the status of the dataset group, call DescribeDatasetGroup. If
the status shows as CREATE FAILED, the response includes a
\code{failureReason} key, which describes why the creation failed.

You must wait until the \code{status} of the dataset group is \code{ACTIVE} before
adding a dataset to the group.

You can specify an AWS Key Management Service (KMS) key to encrypt the
datasets in the group. If you specify a KMS key, you must also include
an AWS Identity and Access Management (IAM) role that has permission to
access the key.

\strong{APIs that require a dataset group ARN in the request}
\itemize{
\item CreateDataset
\item CreateEventTracker
\item CreateSolution
}

\strong{Related APIs}
\itemize{
\item ListDatasetGroups
\item DescribeDatasetGroup
\item DeleteDatasetGroup
}
}
\section{Request syntax}{
\preformatted{svc$create_dataset_group(
  name = "string",
  roleArn = "string",
  kmsKeyArn = "string"
)
}
}

\keyword{internal}
