% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_actions}
\alias{sagemaker_list_actions}
\title{Lists the actions in your account and their properties}
\usage{
sagemaker_list_actions(SourceUri, ActionType, CreatedAfter,
  CreatedBefore, SortBy, SortOrder, NextToken, MaxResults)
}
\arguments{
\item{SourceUri}{A filter that returns only actions with the specified source URI.}

\item{ActionType}{A filter that returns only actions of the specified type.}

\item{CreatedAfter}{A filter that returns only actions created on or after the specified
time.}

\item{CreatedBefore}{A filter that returns only actions created on or before the specified
time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}

\item{NextToken}{If the previous call to \code{\link[=sagemaker_list_actions]{list_actions}} didn't
return the full set of actions, the call returns a token for getting the
next set of actions.}

\item{MaxResults}{The maximum number of actions to return in the response. The default
value is 10.}
}
\value{
A list with the following syntax:\preformatted{list(
  ActionSummaries = list(
    list(
      ActionArn = "string",
      ActionName = "string",
      Source = list(
        SourceUri = "string",
        SourceType = "string",
        SourceId = "string"
      ),
      ActionType = "string",
      Status = "Unknown"|"InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the actions in your account and their properties.
}
\section{Request syntax}{
\preformatted{svc$list_actions(
  SourceUri = "string",
  ActionType = "string",
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
