% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_experiment}
\alias{sagemaker_delete_experiment}
\title{Deletes an Amazon SageMaker experiment}
\usage{
sagemaker_delete_experiment(ExperimentName)
}
\arguments{
\item{ExperimentName}{[required] The name of the experiment to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  ExperimentArn = "string"
)
}
}
\description{
Deletes an Amazon SageMaker experiment. All trials associated with the
experiment must be deleted first. Use the
\code{\link[=sagemaker_list_trials]{list_trials}} API to get a list of the trials
associated with the experiment.
}
\section{Request syntax}{
\preformatted{svc$delete_experiment(
  ExperimentName = "string"
)
}
}

\keyword{internal}
