% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_artifact}
\alias{sagemaker_delete_artifact}
\title{Deletes an artifact}
\usage{
sagemaker_delete_artifact(ArtifactArn, Source)
}
\arguments{
\item{ArtifactArn}{The Amazon Resource Name (ARN) of the artifact to delete.}

\item{Source}{The URI of the source.}
}
\value{
A list with the following syntax:\preformatted{list(
  ArtifactArn = "string"
)
}
}
\description{
Deletes an artifact. Either \code{ArtifactArn} or \code{Source} must be specified.
}
\section{Request syntax}{
\preformatted{svc$delete_artifact(
  ArtifactArn = "string",
  Source = list(
    SourceUri = "string",
    SourceTypes = list(
      list(
        SourceIdType = "MD5Hash"|"S3ETag"|"S3Version"|"Custom",
        Value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
