% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_chat_contact}
\alias{connect_start_chat_contact}
\title{Initiates a contact flow to start a new chat for the customer}
\usage{
connect_start_chat_contact(InstanceId, ContactFlowId, Attributes,
  ParticipantDetails, InitialMessage, ClientToken)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{ContactFlowId}{[required] The identifier of the contact flow for initiating the chat. To see the
ContactFlowId in the Amazon Connect console user interface, on the
navigation menu go to \strong{Routing}, \strong{Contact Flows}. Choose the contact
flow. On the contact flow page, under the name of the contact flow,
choose \strong{Show additional flow information}. The ContactFlowId is the
last part of the ARN, shown here in bold:

arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/\strong{846ec553-a005-41c0-8341-xxxxxxxxxxxx}}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in contact flows
just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{ParticipantDetails}{[required] Information identifying the participant.}

\item{InitialMessage}{The initial message to be sent to the newly created chat.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  ContactId = "string",
  ParticipantId = "string",
  ParticipantToken = "string"
)
}
}
\description{
Initiates a contact flow to start a new chat for the customer. Response
of this API provides a token required to obtain credentials from the
\href{https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html}{CreateParticipantConnection}
API in the Amazon Connect Participant Service.

When a new chat contact is successfully created, clients need to
subscribe to the participant’s connection for the created chat within 5
minutes. This is achieved by invoking
\href{https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html}{CreateParticipantConnection}
with WEBSOCKET and CONNECTION_CREDENTIALS.

A 429 error occurs in two situations:
\itemize{
\item API rate limit is exceeded. API TPS throttling returns a
\code{TooManyRequests} exception from the API Gateway.
\item The \href{https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html}{quota for concurrent active chats}
is exceeded. Active chat throttling returns a
\code{LimitExceededException}.
}

For more information about how chat works, see
\href{https://docs.aws.amazon.com/connect/latest/adminguide/chat.html}{Chat}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_chat_contact(
  InstanceId = "string",
  ContactFlowId = "string",
  Attributes = list(
    "string"
  ),
  ParticipantDetails = list(
    DisplayName = "string"
  ),
  InitialMessage = list(
    ContentType = "string",
    Content = "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
