% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_receipt_rule_position}
\alias{ses_set_receipt_rule_position}
\title{Sets the position of the specified receipt rule in the receipt rule set}
\usage{
ses_set_receipt_rule_position(RuleSetName, RuleName, After)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set that contains the receipt rule to
reposition.}

\item{RuleName}{[required] The name of the receipt rule to reposition.}

\item{After}{The name of the receipt rule after which to place the specified receipt
rule.}
}
\description{
Sets the position of the specified receipt rule in the receipt rule set.
}
\details{
For information about managing receipt rules, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$set_receipt_rule_position(
  RuleSetName = "string",
  RuleName = "string",
  After = "string"
)
}
}

\examples{
# The following example sets the position of a receipt rule in a receipt
# rule set:
\donttest{svc$set_receipt_rule_position(
  After = "PutRuleAfterThisRule",
  RuleName = "RuleToReposition",
  RuleSetName = "MyRuleSet"
)}

}
\keyword{internal}
