# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Payment Cryptography Data Plane
#'
#' @description
#' You use the Amazon Web Services Payment Cryptography Data Plane to
#' manage how encryption keys are used for payment-related transaction
#' processing and associated cryptographic operations. You can encrypt,
#' decrypt, generate, verify, and translate payment-related cryptographic
#' operations in Amazon Web Services Payment Cryptography. For more
#' information, see [Data
#' operations](https://docs.aws.amazon.com/payment-cryptography/latest/userguide/data-operations.html)
#' in the *Amazon Web Services Payment Cryptography User Guide*.
#' 
#' To manage your encryption keys, you use the [Amazon Web Services Payment
#' Cryptography Control
#' Plane](https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/Welcome.html).
#' You can create, import, export, share, manage, and delete keys. You can
#' also manage Identity and Access Management (IAM) policies for keys.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- paymentcryptographydataplane(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- paymentcryptographydataplane()
#' svc$decrypt_data(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=paymentcryptographydataplane_decrypt_data]{decrypt_data} \tab Decrypts ciphertext data to plaintext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme\cr
#'  \link[=paymentcryptographydataplane_encrypt_data]{encrypt_data} \tab Encrypts plaintext data to ciphertext using a symmetric (TDES, AES), asymmetric (RSA), or derived (DUKPT or EMV) encryption key scheme\cr
#'  \link[=paymentcryptographydataplane_generate_card_validation_data]{generate_card_validation_data} \tab Generates card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security Codes (CSC)\cr
#'  \link[=paymentcryptographydataplane_generate_mac]{generate_mac} \tab Generates a Message Authentication Code (MAC) cryptogram within Amazon Web Services Payment Cryptography\cr
#'  \link[=paymentcryptographydataplane_generate_pin_data]{generate_pin_data} \tab Generates pin-related data such as PIN, PIN Verification Value (PVV), PIN Block, and PIN Offset during new card issuance or reissuance\cr
#'  \link[=paymentcryptographydataplane_re_encrypt_data]{re_encrypt_data} \tab Re-encrypt ciphertext using DUKPT or Symmetric data encryption keys\cr
#'  \link[=paymentcryptographydataplane_translate_pin_data]{translate_pin_data} \tab Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4\cr
#'  \link[=paymentcryptographydataplane_verify_auth_request_cryptogram]{verify_auth_request_cryptogram} \tab Verifies Authorization Request Cryptogram (ARQC) for a EMV chip payment card authorization\cr
#'  \link[=paymentcryptographydataplane_verify_card_validation_data]{verify_card_validation_data} \tab Verifies card-related validation data using algorithms such as Card Verification Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card Security Codes (CSC)\cr
#'  \link[=paymentcryptographydataplane_verify_mac]{verify_mac} \tab Verifies a Message Authentication Code (MAC)\cr
#'  \link[=paymentcryptographydataplane_verify_pin_data]{verify_pin_data} \tab Verifies pin-related data such as PIN and PIN Offset using algorithms including VISA PVV and IBM3624
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname paymentcryptographydataplane
#' @export
paymentcryptographydataplane <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .paymentcryptographydataplane$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.paymentcryptographydataplane <- list()

.paymentcryptographydataplane$operations <- list()

.paymentcryptographydataplane$metadata <- list(
  service_name = "paymentcryptographydataplane",
  endpoints = list("*" = list(endpoint = "dataplane.payment-cryptography.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "dataplane.payment-cryptography.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "dataplane.payment-cryptography.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "dataplane.payment-cryptography.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "dataplane.payment-cryptography.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "dataplane.payment-cryptography.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Payment Cryptography Data",
  api_version = "2022-02-03",
  signing_name = "payment-cryptography",
  json_version = "",
  target_prefix = ""
)

.paymentcryptographydataplane$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.paymentcryptographydataplane$metadata, handlers, config, op)
}
